---
generated_at: 2025-12-26 12:05:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：172-出庫編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **アクションの詳細な処理内容**：各Actionクラスの実装を詳細確認が必要
  2. **在庫更新の具体的なロジック**：確定時の在庫更新処理の詳細

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/inventories/src/Filament/Clusters/Operations/Resources/DeliveryResource/Pages/EditDelivery.php`
- E-02: `plugins/webkul/inventories/src/Filament/Clusters/Operations/Resources/DeliveryResource.php`
- E-03: `plugins/webkul/inventories/src/Filament/Clusters/Operations/Resources/OperationResource.php`
- E-04: `plugins/webkul/inventories/src/Models/Operation.php`
- E-05: `plugins/webkul/inventories/src/Filament/Clusters/Operations/Actions/` (各Actionクラス)
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLは `/inventories/operations/deliveries/{record}/edit` | E-02 (getPages: EditDelivery::route('/{record}/edit')) | ○ |
| C-02 | EditDeliveryクラスがEditRecordを継承 | E-01 (class EditDelivery extends EditRecord) | ○ |
| C-03 | HasRecordNavigationTabsトレイトを使用 | E-01 (use HasRecordNavigationTabs) | ○ |
| C-04 | 保存後は編集画面にリダイレクト | E-01 (getRedirectUrl: getResource()::getUrl('edit')) | ○ |
| C-05 | ChatterActionが利用可能 | E-01 (ChatterAction::make()) | ○ |
| C-06 | TodoActionが利用可能 | E-01 (OperationActions\TodoAction::make()) | ○ |
| C-07 | CheckAvailabilityActionが利用可能 | E-01 (OperationActions\CheckAvailabilityAction::make()) | ○ |
| C-08 | ValidateActionが利用可能 | E-01 (OperationActions\ValidateAction::make()) | ○ |
| C-09 | CancelActionが利用可能 | E-01 (OperationActions\CancelAction::make()) | ○ |
| C-10 | ReturnActionが利用可能 | E-01 (OperationActions\ReturnAction::make()) | ○ |
| C-11 | 印刷アクションがActionGroupでグループ化 | E-01 (ActionGroup::make([Print\...Action])) | ○ |
| C-12 | PickingOperationAction | E-01 (Print\PickingOperationAction::make()) | ○ |
| C-13 | DeliverySlipAction | E-01 (Print\DeliverySlipAction::make()) | ○ |
| C-14 | PackageAction | E-01 (Print\PackageAction::make()) | ○ |
| C-15 | LabelsAction | E-01 (Print\LabelsAction::make()) | ○ |
| C-16 | DeleteActionはstate==DONEで非表示 | E-01 (hidden: $this->getRecord()->state == OperationState::DONE) | ○ |
| C-17 | 削除時にQueryExceptionをキャッチ | E-01 (catch (QueryException $e)) | ○ |
| C-18 | updateFormメソッドが存在 | E-01 (public function updateForm(): void { $this->fillForm(); }) | ○ |
| C-19 | フォームはOperationResourceから共有 | E-02 (form: OperationResource::form($schema)) | ○ |
| C-20 | 成功通知が表示される | E-01 (getSavedNotification: Notification::make()->success()) | ○ |
| C-21 | 削除成功通知が表示される | E-01 (successNotification: Notification::make()->success()) | ○ |
| C-22 | 削除エラー通知が表示される | E-01 (Notification::make()->danger()) | ○ |
| C-23 | 画面No.172は出庫編集画面 | E-06 (No.172, 出庫編集) | ○ |
| C-24 | 印刷ボタンはgray色 | E-01 (->color('gray')) | ○ |
| C-25 | 印刷ボタンのアイコンはprinter | E-01 (->icon('heroicon-o-printer')) | ○ |
| C-26 | サブナビゲーションでView/Edit/Movesに遷移可能 | E-02 (getRecordSubNavigation) | ○ |
| C-27 | 確定時に在庫が更新される | **根拠要確認** | △ |
| C-28 | 返品時に新規オペレーションが作成される | **根拠要確認** | △ |

## 4) 不足情報（Unknown / Missing）
- 各Actionクラスの詳細実装
  - 候補：`plugins/webkul/inventories/src/Filament/Clusters/Operations/Actions/`配下
- 確定時の在庫更新処理の詳細ロジック
  - 候補：`ValidateAction.php`の実装

## 5) リスクフラグ（レビュー観点）
- 0: ヘッダーアクションの構成（コードと整合）
- 0: 表示制御条件（コードと整合）
- 1: 確定・返品アクションの詳細処理（要確認）
- 0: 通知メッセージ（コードと整合）

## 6) レビュアーチェックリスト（最小）
- [ ] 各Actionクラスの詳細実装を確認
- [ ] 確定時の在庫更新処理を確認
- [ ] 返品オペレーション作成処理を確認
- [ ] 実際の画面動作と設計書の整合性を確認
