---
generated_at: 2025-12-26 12:10:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：173-出庫詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **infolistの詳細内容**：OperationResourceのinfolist定義を詳細確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/inventories/src/Filament/Clusters/Operations/Resources/DeliveryResource/Pages/ViewDelivery.php`
- E-02: `plugins/webkul/inventories/src/Filament/Clusters/Operations/Resources/DeliveryResource.php`
- E-03: `plugins/webkul/inventories/src/Filament/Clusters/Operations/Resources/OperationResource.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLは `/inventories/operations/deliveries/{record}/view` | E-02 (getPages: ViewDelivery::route('/{record}/view')) | ○ |
| C-02 | ViewDeliveryクラスがViewRecordを継承 | E-01 (class ViewDelivery extends ViewRecord) | ○ |
| C-03 | HasRecordNavigationTabsトレイトを使用 | E-01 (use HasRecordNavigationTabs) | ○ |
| C-04 | HasRepeatableEntryColumnManagerを使用 | E-01 (use HasRepeatableEntryColumnManager) | ○ |
| C-05 | ChatterActionが利用可能 | E-01 (ChatterAction::make()) | ○ |
| C-06 | 印刷アクションがActionGroupでグループ化 | E-01 (ActionGroup::make([...])) | ○ |
| C-07 | PickingOperationAction | E-01 (OperationActions\Print\PickingOperationAction::make()) | ○ |
| C-08 | DeliverySlipAction | E-01 (OperationActions\Print\DeliverySlipAction::make()) | ○ |
| C-09 | PackageAction | E-01 (OperationActions\Print\PackageAction::make()) | ○ |
| C-10 | LabelsAction | E-01 (OperationActions\Print\LabelsAction::make()) | ○ |
| C-11 | DeleteActionはstate==DONEで非表示 | E-01 (hidden: $this->getRecord()->state == OperationState::DONE) | ○ |
| C-12 | 削除時にQueryExceptionをキャッチ | E-01 (catch (QueryException $e)) | ○ |
| C-13 | infolistはOperationResourceから共有 | E-02 (infolist: OperationResource::infolist($schema)) | ○ |
| C-14 | 画面No.173は出庫詳細画面 | E-04 (No.173, 出庫詳細) | ○ |
| C-15 | 印刷ボタンはgray色 | E-01 (->color('gray')) | ○ |
| C-16 | 印刷ボタンのアイコンはprinter | E-01 (->icon('heroicon-o-printer')) | ○ |
| C-17 | 削除成功通知が表示される | E-01 (successNotification: Notification::make()->success()) | ○ |
| C-18 | 削除エラー通知が表示される | E-01 (Notification::make()->danger()) | ○ |
| C-19 | サブナビゲーションでView/Edit/Movesに遷移可能 | E-02 (getRecordSubNavigation) | ○ |
| C-20 | 表示項目の詳細内容 | **根拠要確認** | △ |

## 4) 不足情報（Unknown / Missing）
- OperationResourceのinfolist定義の詳細
  - 候補：`OperationResource.php`の`infolist`メソッド

## 5) リスクフラグ（レビュー観点）
- 0: ヘッダーアクションの構成（コードと整合）
- 0: 表示制御条件（コードと整合）
- 1: 表示項目の詳細（要確認）
- 0: 通知メッセージ（コードと整合）

## 6) レビュアーチェックリスト（最小）
- [ ] OperationResourceのinfolist定義を確認
- [ ] 表示項目が実際の画面と一致するか確認
- [ ] 実際の画面動作と設計書の整合性を確認
