---
generated_at: 2025-12-26 12:15:00
metrics:
  claims_total: 35
  claims_with_evidence: 34
  claims_without_evidence: 1
confidence_derived: 0.97
---

# 根拠レポート：174-数量管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：34 / 35、根拠なし：1
- 優先レビュー（高）
  1. **在庫移動レコード作成の詳細**：ProductResource::createMoveの実装確認

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/inventories/src/Filament/Clusters/Operations/Resources/QuantityResource/Pages/ManageQuantities.php`
- E-02: `plugins/webkul/inventories/src/Filament/Clusters/Operations/Resources/QuantityResource.php`
- E-03: `plugins/webkul/inventories/src/Models/ProductQuantity.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLは `/inventories/operations/quantities` | E-02 (getPages: ManageQuantities::route('/')) | ○ |
| C-02 | ManageQuantitiesクラスがManageRecordsを継承 | E-01 (class ManageQuantities extends ManageRecords) | ○ |
| C-03 | HasTableViewsトレイトを使用 | E-01 (use HasTableViews) | ○ |
| C-04 | PresetView internal_locationsがある | E-01 (PresetView::make(...internal-locations)) | ○ |
| C-05 | PresetView transit_locationsがある | E-01 (PresetView::make(...transit-locations)) | ○ |
| C-06 | PresetView on_handがある | E-01 (PresetView::make(...on-hand)) | ○ |
| C-07 | PresetView to_countがある | E-01 (PresetView::make(...to-count)) | ○ |
| C-08 | PresetView to_applyがある | E-01 (PresetView::make(...to-apply)) | ○ |
| C-09 | internal_locationsはLocationType::INTERNALでフィルタ | E-01 (query->where('type', LocationType::INTERNAL)) | ○ |
| C-10 | transit_locationsはLocationType::TRANSITでフィルタ | E-01 (query->where('type', LocationType::TRANSIT)) | ○ |
| C-11 | on_handはquantity > 0でフィルタ | E-01 (query->where('quantity', '>', 0)) | ○ |
| C-12 | to_countはscheduled_at > now()でフィルタ | E-01 (query->where('scheduled_at', '>', now())) | ○ |
| C-13 | to_applyはinventory_quantity_set = trueでフィルタ | E-01 (query->where('inventory_quantity_set', true)) | ○ |
| C-14 | フォームにlocation_id選択がある | E-02 (Select::make('location_id')) | ○ |
| C-15 | フォームにproduct_id選択がある | E-02 (Select::make('product_id')) | ○ |
| C-16 | フォームにlot_id選択がある | E-02 (Select::make('lot_id')) | ○ |
| C-17 | フォームにpackage_id選択がある | E-02 (Select::make('package_id')) | ○ |
| C-18 | フォームにcounted_quantity入力がある | E-02 (TextInput::make('counted_quantity')) | ○ |
| C-19 | フォームにscheduled_at選択がある | E-02 (DatePicker::make('scheduled_at')) | ○ |
| C-20 | テーブルにlocation.full_name列がある | E-02 (TextColumn::make('location.full_name')) | ○ |
| C-21 | テーブルにproduct.name列がある | E-02 (TextColumn::make('product.name')) | ○ |
| C-22 | テーブルにlot.name列がある | E-02 (TextColumn::make('lot.name')) | ○ |
| C-23 | テーブルにcounted_quantity列がある（インライン編集可能） | E-02 (TextInputColumn::make('counted_quantity')) | ○ |
| C-24 | テーブルにinventory_diff_quantity列がある | E-02 (TextColumn::make('inventory_diff_quantity')) | ○ |
| C-25 | 差異列は正=緑、負=赤で表示 | E-02 (color: $record->inventory_diff_quantity > 0 ? 'success' : 'danger') | ○ |
| C-26 | applyアクションがある | E-02 (Action::make('apply')) | ○ |
| C-27 | clearアクションがある | E-02 (Action::make('clear')) | ○ |
| C-28 | applyはinventory_quantity_set=trueの時のみ表示 | E-02 (visible: fn (ProductQuantity $record) => $record->inventory_quantity_set) | ○ |
| C-29 | clearはinventory_quantity_set=trueの時のみ表示 | E-02 (visible: fn (ProductQuantity $record) => $record->inventory_quantity_set) | ○ |
| C-30 | QueryBuilderフィルタを使用 | E-02 (QueryBuilder::make()->constraints([...])) | ○ |
| C-31 | INTERNALとTRANSITのロケーションのみ表示 | E-02 (whereIn('type', [LocationType::INTERNAL, LocationType::TRANSIT])) | ○ |
| C-32 | 削除済み商品は非表示 | E-02 (whereNull('deleted_at')) | ○ |
| C-33 | 画面No.174は数量管理画面 | E-04 (No.174, 数量管理) | ○ |
| C-34 | 新規作成時に重複チェックを行う | E-02 (before: existingQuantity exists check, halt()) | ○ |
| C-35 | 在庫移動レコードが作成される | **根拠要確認** | △ |

## 4) 不足情報（Unknown / Missing）
- ProductResource::createMoveの実装詳細
  - 候補：`plugins/webkul/inventories/src/Filament/Clusters/Products/Resources/ProductResource.php`

## 5) リスクフラグ（レビュー観点）
- 0: テーブル列の構成（コードと整合）
- 0: フォーム項目の構成（コードと整合）
- 0: プリセットビューの条件（コードと整合）
- 1: 適用時の在庫移動処理（要確認）
- 0: フィルター条件（コードと整合）

## 6) レビュアーチェックリスト（最小）
- [ ] ProductResource::createMoveの実装を確認
- [ ] 適用時の在庫更新処理が正しいか確認
- [ ] 実際の画面動作と設計書の整合性を確認
