---
generated_at: 2025-12-26 12:35:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：178-ドロップシップ作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 特になし（全項目で根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/inventories/src/Filament/Clusters/Operations/Resources/DropshipResource/Pages/CreateDropship.php`
- E-02: `plugins/webkul/inventories/src/Filament/Clusters/Operations/Resources/DropshipResource.php`
- E-03: `plugins/webkul/inventories/src/Filament/Clusters/Operations/Resources/OperationResource.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | URLは `/inventories/operations/dropships/create` | E-02 (getPages: CreateDropship::route('/create')) | ○ |
| C-02 | CreateDropshipクラスがCreateRecordを継承 | E-01 (class CreateDropship extends CreateRecord) | ○ |
| C-03 | mount時にDROPSHIPタイプを取得 | E-01 (OperationType::where('type', Enums\OperationType::DROPSHIP)->first()) | ○ |
| C-04 | operation_type_idが自動設定される | E-01 ($this->data['operation_type_id'] = $operationType?->id) | ○ |
| C-05 | source_location_idが自動設定される | E-01 ($this->data['source_location_id'] = $operationType?->source_location_id) | ○ |
| C-06 | destination_location_idが自動設定される | E-01 ($this->data['destination_location_id'] = $operationType?->destination_location_id) | ○ |
| C-07 | 作成後は編集画面にリダイレクト | E-01 (getRedirectUrl: getResource()::getUrl('edit')) | ○ |
| C-08 | stateはDRAFTで初期化される | E-01 (mutateFormDataBeforeCreate: OperationState::DRAFT) | ○ |
| C-09 | creator_idにはAuth::id()が設定される | E-01 (mutateFormDataBeforeCreate: $data['creator_id'] = Auth::id()) | ○ |
| C-10 | company_idは出庫先ロケーションの会社ID | E-01 ($data['company_id'] ??= $operationType->destinationLocation->company_id) | ○ |
| C-11 | フォームはOperationResourceから共有される | E-02 (form: OperationResource::form($schema)) | ○ |
| C-12 | getSubNavigationメソッドがある | E-01 (public function getSubNavigation(): array) | ○ |
| C-13 | 成功通知が表示される | E-01 (getCreatedNotification: Notification::make()->success()) | ○ |
| C-14 | 画面No.178はドロップシップ作成画面 | E-04 (No.178, ドロップシップ作成) | ○ |
| C-15 | getSubNavigationでclusterコンポーネントを使用 | E-01 (generateNavigationItems($cluster::getClusteredComponents())) | ○ |
| C-16 | source_location_idは??=演算子でフォールバック設定 | E-01 ($data['source_location_id'] ??= $operationType->source_location_id) | ○ |
| C-17 | destination_location_idは??=演算子でフォールバック設定 | E-01 ($data['destination_location_id'] ??= $operationType->destination_location_id) | ○ |
| C-18 | stateも??=演算子でフォールバック設定 | E-01 ($data['state'] ??= OperationState::DRAFT) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: マウント処理（コードと整合）
- 0: データ変換処理（コードと整合）
- 0: フォーム共有（コードと整合）
- 0: リダイレクト処理（コードと整合）

## 6) レビュアーチェックリスト（最小）
- [ ] 実際の画面動作と設計書の整合性を確認
- [ ] DROPSHIPタイプのオペレーションタイプが正しく設定されるか確認
