---
generated_at: 2025-12-26 18:00:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：18-クレジットノート詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/accounts/src/Filament/Resources/CreditNoteResource/Pages/ViewCreditNote.php`
- E-02: `plugins/webkul/accounts/src/Filament/Resources/CreditNoteResource.php`
- E-03: `plugins/webkul/accounts/src/Filament/Resources/InvoiceResource.php`
- E-04: `plugins/webkul/accounts/src/Filament/Resources/InvoiceResource/Pages/ViewInvoice.php`
- E-05: `plugins/webkul/accounts/src/Models/Move.php`
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面名は「クレジットノート詳細」である | E-06 | ○ |
| C-02 | ViewInvoice（ViewRecord）を継承している | E-01 | ○ |
| C-03 | set-as-checkedとcredit-noteアクションは除外 | E-01 (getHeaderActions filter) | ○ |
| C-04 | プレビューはクレジットノート専用テンプレートを使用 | E-01 (PreviewAction setTemplate) | ○ |
| C-05 | 親クラスViewInvoiceにヘッダーアクションがある | E-04 (getHeaderActions) | ○ |
| C-06 | ChatterAction, PayAction, ConfirmAction等がある | E-04 (getHeaderActions) | ○ |
| C-07 | DeleteActionに成功通知が設定されている | E-04 (DeleteAction successNotification) | ○ |
| C-08 | infolistでスキーマが定義されている | E-03 (infolist method) | ○ |
| C-09 | 支払状態がバッジで表示される | E-03 (TextEntry payment_state badge) | ○ |
| C-10 | RepeatableEntryで明細表示 | E-03 (RepeatableEntry lines) | ○ |
| C-11 | タブ構成（明細、その他情報、利用規約） | E-03 (Tabs) | ○ |
| C-12 | InvoiceSummaryコンポーネントで合計表示 | E-03 (Livewire InvoiceSummary) | ○ |
| C-13 | 各項目にアイコンが設定されている | E-03 (icon属性) | ○ |
| C-14 | プレースホルダーに'-'が設定されている | E-03 (placeholder('-')) | ○ |
| C-15 | narrationはHTMLレンダリング | E-03 (narration html) | ○ |
| C-16 | ルーティングは'/{record}' | E-02 (getPages) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] ヘッダーアクションのフィルタリングが正しく動作するか確認
- [ ] プレビューがクレジットノート専用テンプレートで表示されるか確認
- [ ] 明細の表示が正しく行われるか確認
