---
generated_at: 2025-12-26 12:00:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：181-物流設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **権限管理の詳細仕様**：Filament Shield連携の詳細は要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/inventories/src/Filament/Clusters/Settings/Pages/ManageLogistics.php`
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv`（行182）
- E-03: `Webkul\Inventory\Settings\LogisticSettings`（参照されているSettings クラス）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URLは`/admin/settings/inventory/manage-logistics` | E-01（slug定義より） | ○ |
| C-02 | ナビゲーショングループはInventory | E-01（$navigationGroup） | ○ |
| C-03 | ナビゲーションソートは5 | E-01（$navigationSort） | ○ |
| C-04 | HasPageShieldで権限制御 | E-01（use HasPageShield） | ○ |
| C-05 | ドロップシッピング有効化トグルがある | E-01（Toggle::make('enable_dropshipping')） | ○ |
| C-06 | 設定保存時にOperationTypeを更新 | E-01（afterSave()メソッド） | ○ |
| C-07 | ドロップシップタイプのオペレーションを論理削除 | E-01（deleted_at更新ロジック） | ○ |
| C-08 | LogisticSettingsクラスで設定管理 | E-01（$settings = LogisticSettings::class） | ○ |
| C-09 | Settingsクラスターに属する | E-01（$cluster = Settings::class） | ○ |
| C-10 | パンくずリストがある | E-01（getBreadcrumbs()メソッド） | ○ |
| C-11 | 多言語対応している | E-01（__()関数使用） | ○ |
| C-12 | 403エラーページへリダイレクトされる | **根拠なし**（Filament Shieldのデフォルト動作） | △ |

## 4) 不足情報（Unknown / Missing）
- 権限がない場合の具体的な挙動はFilament Shieldのデフォルト動作に依存
  - 候補：Filament Shieldドキュメント / Filament公式ドキュメント / HasPageShieldトレイト実装

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な機能仕様はコードから確認できる
- 1: 中リスク - 権限エラー時の挙動はフレームワーク依存

## 6) レビュアーチェックリスト（最小）
- [ ] ドロップシッピング有効化トグルの動作確認
- [ ] 設定保存後のオペレーションタイプ論理削除動作確認
- [ ] 権限がないユーザーでのアクセス時の挙動確認
