---
generated_at: 2025-12-26 12:05:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：182-オペレーション設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/inventories/src/Filament/Clusters/Settings/Pages/ManageOperations.php`
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv`（行183）
- E-03: `Webkul\Inventory\Settings\OperationSettings`（参照されているSettingsクラス）
- E-04: `Webkul\Inventory\Filament\Clusters\Products\Resources\PackageResource`（リンク先リソース）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URLは`/admin/settings/inventory/manage-operations` | E-01（slug定義より） | ○ |
| C-02 | ナビゲーショングループはInventory | E-01（$navigationGroup） | ○ |
| C-03 | ナビゲーションソートは1 | E-01（$navigationSort = 1） | ○ |
| C-04 | HasPageShieldで権限制御 | E-01（use HasPageShield） | ○ |
| C-05 | パッケージ有効化トグルがある | E-01（Toggle::make('enable_packages')） | ○ |
| C-06 | 年次棚卸日入力フィールドがある | E-01（TextInput::make('annual_inventory_day')） | ○ |
| C-07 | 年次棚卸月選択フィールドがある | E-01（Select::make('annual_inventory_month')） | ○ |
| C-08 | 日付は1-31の範囲 | E-01（->minValue(1)->maxValue(31)） | ○ |
| C-09 | 月は1-12の選択肢 | E-01（optionsで1-12を定義） | ○ |
| C-10 | パッケージ管理画面へのリンクがある | E-01（PackageResource::getUrl()） | ○ |
| C-11 | OperationSettingsクラスで設定管理 | E-01（$settings = OperationSettings::class） | ○ |
| C-12 | Settingsクラスターに属する | E-01（$cluster = Settings::class） | ○ |
| C-13 | パンくずリストがある | E-01（getBreadcrumbs()メソッド） | ○ |
| C-14 | 多言語対応している | E-01（__()関数使用、月名も多言語対応） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がコードから確認できる

## 6) レビュアーチェックリスト（最小）
- [ ] パッケージ有効化トグルの動作確認
- [ ] 年次棚卸日・月の入力と保存動作確認
- [ ] パッケージ管理画面へのリンク動作確認
