---
generated_at: 2025-12-26 12:10:00
metrics:
  claims_total: 15
  claims_with_evidence: 15
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：183-トレーサビリティ設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：15 / 15、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/inventories/src/Filament/Clusters/Settings/Pages/ManageTraceability.php`
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv`（行184）
- E-03: `Webkul\Inventory\Settings\TraceabilitySettings`（参照されているSettingsクラス）
- E-04: `Webkul\Inventory\Enums\ProductTracking`（SERIAL, LOT定数）
- E-05: `Webkul\Inventory\Filament\Clusters\Products\Resources\LotResource`（リンク先リソース）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URLは`/admin/settings/inventory/manage-traceability` | E-01（slug定義より） | ○ |
| C-02 | ナビゲーショングループはInventory | E-01（$navigationGroup） | ○ |
| C-03 | ナビゲーションソートは4 | E-01（$navigationSort = 4） | ○ |
| C-04 | HasPageShieldで権限制御 | E-01（use HasPageShield） | ○ |
| C-05 | ロット/シリアル番号有効化トグルがある | E-01（Toggle::make('enable_lots_serial_numbers')） | ○ |
| C-06 | 配送伝票表示トグルがある | E-01（Toggle::make('display_on_delivery_slips')） | ○ |
| C-07 | 配送伝票表示は条件付き表示 | E-01（->visible(fn (Get $get) => $get('enable_lots_serial_numbers'))） | ○ |
| C-08 | トグルはliveで連動 | E-01（->live()） | ○ |
| C-09 | ロット管理画面へのリンクがある | E-01（LotResource::getUrl()） | ○ |
| C-10 | TraceabilitySettingsクラスで設定管理 | E-01（$settings = TraceabilitySettings::class） | ○ |
| C-11 | beforeSaveで既存データチェック | E-01（beforeSave()メソッド） | ○ |
| C-12 | SERIAL/LOT追跡商品存在時は保存ブロック | E-01（Product::whereIn('tracking', [ProductTracking::SERIAL, ProductTracking::LOT])） | ○ |
| C-13 | 警告通知を表示 | E-01（Notification::make()->warning()） | ○ |
| C-14 | halt()で保存中止 | E-01（$this->halt()） | ○ |
| C-15 | 多言語対応している | E-01（__()関数使用） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がコードから確認できる

## 6) レビュアーチェックリスト（最小）
- [ ] ロット/シリアル番号有効化トグルの動作確認
- [ ] 配送伝票表示トグルの条件付き表示確認
- [ ] 既存追跡設定商品がある場合の保存ブロック動作確認
- [ ] ロット管理画面へのリンク動作確認
