---
generated_at: 2025-12-26 12:20:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：185-倉庫設定

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/inventories/src/Filament/Clusters/Settings/Pages/ManageWarehouses.php`
- E-02: `docs/code-to-docs/画面一覧/画面一覧.csv`（行186）
- E-03: `Webkul\Inventory\Settings\WarehouseSettings`（参照されているSettingsクラス）
- E-04: `Webkul\Inventory\Filament\Clusters\Configurations\Resources\LocationResource`（リンク先リソース）
- E-05: `Webkul\Inventory\Filament\Clusters\Configurations\Resources\WarehouseResource`（リンク先リソース）
- E-06: `Webkul\Inventory\Models\Warehouse`（倉庫モデル）
- E-07: `Webkul\Inventory\Models\OperationType`（オペレーションタイプモデル）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面URLは`/admin/settings/inventory/manage-warehouses` | E-01（slug定義より） | ○ |
| C-02 | ナビゲーショングループはInventory | E-01（$navigationGroup） | ○ |
| C-03 | ナビゲーションソートは3 | E-01（$navigationSort = 3） | ○ |
| C-04 | HasPageShieldで権限制御 | E-01（use HasPageShield） | ○ |
| C-05 | ロケーション有効化トグルがある | E-01（Toggle::make('enable_locations')） | ○ |
| C-06 | マルチステップルート有効化トグルがある | E-01（Toggle::make('enable_multi_steps_routes')） | ○ |
| C-07 | ロケーション無効時にマルチステップルートも無効化 | E-01（afterStateUpdated for enable_locations） | ○ |
| C-08 | マルチステップルート有効時にロケーションも有効化 | E-01（afterStateUpdated for enable_multi_steps_routes） | ○ |
| C-09 | ロケーション管理画面へのリンクがある | E-01（LocationResource::getUrl()） | ○ |
| C-10 | 倉庫管理画面へのリンクがある | E-01（WarehouseResource::getUrl()） | ○ |
| C-11 | WarehouseSettingsクラスで設定管理 | E-01（$settings = WarehouseSettings::class） | ○ |
| C-12 | beforeSaveで倉庫数チェック | E-01（beforeSave()メソッド） | ○ |
| C-13 | 倉庫が2つ以上で保存ブロック | E-01（Warehouse::count() > 1） | ○ |
| C-14 | afterSaveで内部移動オペレーションタイプ更新 | E-01（afterSave()メソッド） | ○ |
| C-15 | 各倉庫のinternal_type_idを対象に更新 | E-01（$warehouse->internal_type_id） | ○ |
| C-16 | 警告通知を表示 | E-01（Notification::make()->warning()） | ○ |
| C-17 | halt()で保存中止 | E-01（$this->halt()） | ○ |
| C-18 | トグルはliveで連動 | E-01（->live()） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がコードから確認できる

## 6) レビュアーチェックリスト（最小）
- [ ] ロケーション有効化トグルの動作確認
- [ ] マルチステップルート有効化トグルの動作確認
- [ ] トグル間の連動動作確認
- [ ] 複数倉庫存在時の保存ブロック動作確認
- [ ] 設定保存後の内部移動オペレーションタイプ論理削除動作確認
