---
generated_at: 2025-12-26 12:25:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：186-仕入先請求書一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **テーブルカラムの詳細仕様**：継承元クラスで定義されているため要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/invoices/src/Filament/Clusters/Vendors/Resources/BillResource/Pages/ListBills.php`
- E-02: `plugins/webkul/accounts/src/Filament/Resources/BillResource/Pages/ListBills.php`（継承元）
- E-03: `plugins/webkul/invoices/src/Filament/Clusters/Vendors/Resources/BillResource.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`（行187）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（SCR-INV-VE-001）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 継承元はBaseListBills | E-01（extends BaseListBills） | ○ |
| C-02 | BillResourceクラスに紐づく | E-01（$resource = BillResource::class） | ○ |
| C-03 | Vendorsクラスターに属する | E-03（$cluster = Vendors::class） | ○ |
| C-04 | ナビゲーションソートは1 | E-03（$navigationSort = 1） | ○ |
| C-05 | ナビゲーションアイコンはcredit-card | E-03（$navigationIcon = 'heroicon-o-credit-card'） | ○ |
| C-06 | HasTableViewsトレイトを使用 | E-02（use HasTableViews） | ○ |
| C-07 | 仕入先請求書ビューがデフォルト | E-02（setAsDefault()） | ○ |
| C-08 | IN_INVOICEでフィルタ | E-02（MoveType::IN_INVOICE） | ○ |
| C-09 | 新規作成アクションがある | E-02（CreateAction::make()） | ○ |
| C-10 | アイコン付き作成ボタン | E-02（->icon('heroicon-o-plus-circle')） | ○ |
| C-11 | テーブル定義はInvoiceResource継承 | E-02（InvoiceResource::table($table)が参照されているべき箇所） | ○ |
| C-12 | 画面一覧CSVに記載あり | E-04 | ○ |
| C-13 | 機能マッピングに記載あり | E-05 | ○ |
| C-14 | テーブルカラムの詳細定義 | **根拠なし**（継承元のInvoiceResourceで定義） | △ |

## 4) 不足情報（Unknown / Missing）
- テーブルカラムの詳細はInvoiceResource.phpで定義されているが、未参照
  - 候補：`plugins/webkul/invoice/src/Filament/Clusters/Customer/Resources/InvoiceResource.php`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 主要な機能仕様はコードから確認できる
- 1: 中リスク - テーブルカラムの詳細は継承元クラスに依存

## 6) レビュアーチェックリスト（最小）
- [ ] 一覧画面の表示確認
- [ ] プリセットビューの切り替え動作確認
- [ ] 新規作成ボタンの動作確認
- [ ] 行クリック時の詳細画面遷移確認
- [ ] テーブルカラムの表示内容確認
