---
generated_at: 2025-12-26 12:30:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：187-仕入先請求書作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/invoices/src/Filament/Clusters/Vendors/Resources/BillResource/Pages/CreateBill.php`
- E-02: `plugins/webkul/accounts/src/Filament/Resources/BillResource/Pages/CreateBill.php`（継承元）
- E-03: `plugins/webkul/accounts/src/Filament/Resources/BillResource.php`（フォーム定義）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`（行188）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 継承元はBaseCreateBill | E-01（extends BaseCreateBill） | ○ |
| C-02 | BillResourceクラスに紐づく | E-01（$resource = BillResource::class） | ○ |
| C-03 | 作成後は詳細画面へリダイレクト | E-02（getRedirectUrl()でview URLを返す） | ○ |
| C-04 | move_typeはIN_INVOICEに設定 | E-02（mutateFormDataBeforeCreate） | ○ |
| C-05 | dateは現在日時に設定 | E-02（$data['date'] = now()） | ○ |
| C-06 | afterCreateでcomputeAccountMove実行 | E-02（Account::computeAccountMove($this->getRecord())） | ○ |
| C-07 | 成功通知が表示される | E-02（getCreatedNotification()） | ○ |
| C-08 | 仕入先選択時に銀行口座自動設定 | E-03（afterStateUpdated for partner_id） | ○ |
| C-09 | 仕入先選択時に支払方法自動設定 | E-03（propertyOutboundPaymentMethodLine） | ○ |
| C-10 | 仕入先選択時に支払条件自動設定 | E-03（propertySupplierPaymentTerm） | ○ |
| C-11 | 商品リピーターがある | E-03（getProductRepeater()） | ○ |
| C-12 | 商品選択時に単位自動設定 | E-03（afterProductUpdated） | ○ |
| C-13 | 商品選択時に単価自動設定 | E-03（product.cost or product.price） | ○ |
| C-14 | 商品選択時に税自動設定 | E-03（product.productTaxes） | ○ |
| C-15 | 金額変更時に再計算 | E-03（calculateLineTotals） | ○ |
| C-16 | Tax::collectで税計算 | E-03（Tax::collect($taxIds, $subTotal, $quantity)） | ○ |
| C-17 | 削除された商品は選択不可 | E-03（disableOptionWhen for Deleted） | ○ |
| C-18 | 重複商品選択は不可 | E-03（disableOptionWhen logic） | ○ |
| C-19 | UOM表示は設定依存 | E-03（ProductSettings.enable_uom） | ○ |
| C-20 | InvoiceSummary Livewireコンポーネント使用 | E-03（Livewire::make(InvoiceSummary::class)） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がコードから確認できる

## 6) レビュアーチェックリスト（最小）
- [ ] 仕入先選択時の自動設定動作確認
- [ ] 商品選択時の自動設定動作確認
- [ ] 金額計算（小計・税額・合計）の正確性確認
- [ ] 保存後の詳細画面遷移確認
- [ ] 会計仕訳の自動生成確認
