---
generated_at: 2025-12-26 12:45:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：190-仕入先支払一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  1. なし - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/invoices/src/Filament/Clusters/Vendors/Resources/PaymentsResource/Pages/ListPayments.php`
- E-02: `plugins/webkul/accounts/src/Filament/Resources/PaymentsResource/Pages/ListPayments.php`（継承元）
- E-03: `plugins/webkul/invoices/src/Filament/Clusters/Vendors/Resources/PaymentsResource.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`（行191）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（SCR-INV-VE-003）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 継承元はBaseListPayments | E-01（extends BaseListPayments） | ○ |
| C-02 | PaymentsResourceクラスに紐づく | E-01（$resource = PaymentsResource::class） | ○ |
| C-03 | Vendorsクラスターに属する | E-03（$cluster = Vendors::class） | ○ |
| C-04 | ナビゲーションソートは3 | E-03（$navigationSort = 3） | ○ |
| C-05 | 仕入先支払ビューがある | E-01（'vendor_payments' => PresetView::make()） | ○ |
| C-06 | 仕入先支払ビューがデフォルト | E-01（->setAsDefault()） | ○ |
| C-07 | 仕入先支払ビューがお気に入り | E-01（->favorite()） | ○ |
| C-08 | partner_type=supplierでフィルタ | E-01（->where('partner_type', 'supplier')） | ○ |
| C-09 | HasTableViewsトレイト使用 | E-02（use HasTableViews） | ○ |
| C-10 | 顧客支払ビューがある | E-02（'customer_payments'） | ○ |
| C-11 | ドラフトビューがある | E-02（'draft' with PaymentStatus::DRAFT） | ○ |
| C-12 | 処理中ビューがある | E-02（'in_process' with PaymentStatus::IN_PROCESS） | ○ |
| C-13 | 送信済みビューがある | E-02（'is_sent' with is_sent = true） | ○ |
| C-14 | 銀行照合なしビューがある | E-02（'no_bank_matching' with is_matched = false） | ○ |
| C-15 | 消込済みビューがある | E-02（'is_reconciled' with is_reconciled = true） | ○ |
| C-16 | 新規作成アクションがある | E-02（CreateAction::make()） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張がコードから確認できる

## 6) レビュアーチェックリスト（最小）
- [ ] 一覧画面の表示確認
- [ ] プリセットビューの切り替え動作確認
- [ ] 「仕入先支払」ビューでのフィルタ動作確認
- [ ] 新規作成ボタンの動作確認
- [ ] 行クリック時の詳細画面遷移確認
