---
generated_at: 2025-12-26 18:25:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：192-仕入先一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **権限による表示制御**：具体的な権限設定の確認が必要
  2. **完全なURLパス**：実際のルーティング設定との整合性確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/invoices/src/Filament/Clusters/Vendors/Resources/VendorResource/Pages/ListVendors.php`
- E-02: `plugins/webkul/invoices/src/Filament/Clusters/Vendors/Resources/VendorResource.php`
- E-03: `plugins/webkul/partners/src/Filament/Resources/PartnerResource.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BaseListVendorsを継承している | E-01 Line 8, 10 | ○ |
| C-02 | リソースはVendorResourceを使用 | E-01 Line 12 | ○ |
| C-03 | タイトルは翻訳キーから取得 | E-01 Line 14-17 | ○ |
| C-04 | ヘッダーにCreateActionがある | E-01 Line 40-46 | ○ |
| C-05 | VendorResourceはPartnerResourceを継承 | E-02 Line 36 | ○ |
| C-06 | モデルはPartner | E-02 Line 40 | ○ |
| C-07 | navigationSortは4 | E-02 Line 46 | ○ |
| C-08 | Vendorsクラスターに属する | E-02 Line 48 | ○ |
| C-09 | sub_type = 'supplier'でフィルタ | E-02 Line 206 | ○ |
| C-10 | カード形式のグリッドレイアウト | E-02 Line 199-204 | ○ |
| C-11 | フォームにsales-person, payment-terms等の項目 | E-02 Line 75-96 | ○ |
| C-12 | 購買設定フィールドセットがある | E-02 Line 99-115 | ○ |
| C-13 | 財務ポジションフィールドセットがある | E-02 Line 117-128 | ○ |
| C-14 | 請求書タブがある | E-02 Line 137-177 | ○ |
| C-15 | 内部メモタブがある | E-02 Line 179-184 | ○ |
| C-16 | サブナビゲーションにView, Edit, Contacts, Addresses, BankAccountsがある | E-02 Line 350-358 | ○ |
| C-17 | テーブルにStack/カード形式の列がある | E-03 Line 318-382 | ○ |
| C-18 | フィルターにQueryBuilderを使用 | E-03 Line 396-494 | ○ |
| C-19 | ソフトデリート/復元/完全削除アクションがある | E-03 Line 501-545 | ○ |
| C-20 | 一括アクションがある | E-03 Line 547-583 | ○ |
| C-21 | 権限による表示制御の詳細 | **根拠なし** | △ |
| C-22 | 完全なURLパス | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 権限設定の詳細な定義ファイルが特定できていない
  - 候補：PolicyクラスまたはFilamentのauthorization設定
- 完全なURLパスの検証にはRouteServiceProviderの確認が必要
  - 候補：routes/web.php / Filament Panel Provider設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的な画面構造と機能は明確
- 1: 中リスク - 権限制御の詳細確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] sub_type = 'supplier'フィルタの動作確認
- [ ] カード形式レイアウトの表示確認
- [ ] ソフトデリート/復元機能の動作確認
- [ ] 関連データ存在時の完全削除エラー処理確認
- [ ] 請求書タブのEDI設定項目の動作確認
