---
generated_at: 2025-12-26 18:30:00
metrics:
  claims_total: 16
  claims_with_evidence: 14
  claims_without_evidence: 2
confidence_derived: 0.88
---

# 根拠レポート：193-顧客請求書一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：14 / 16、根拠なし：2
- 優先レビュー（高）
  1. **権限による表示制御**：具体的な権限設定の確認が必要
  2. **転記済み請求書の削除制限**：実際の制御ロジックの確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/invoices/src/Filament/Clusters/Customer/Resources/InvoiceResource/Pages/ListInvoices.php`
- E-02: `plugins/webkul/invoices/src/Filament/Clusters/Customer/Resources/InvoiceResource.php`
- E-03: `plugins/webkul/accounts/src/Filament/Resources/InvoiceResource/Pages/ListInvoices.php`
- E-04: `plugins/webkul/accounts/src/Filament/Resources/InvoiceResource.php`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BaseListInvoicesを継承している | E-01 Line 8 | ○ |
| C-02 | リソースはInvoiceResourceを使用 | E-01 Line 10 | ○ |
| C-03 | HasTableViewsトレイトを使用 | E-03 Line 17 | ○ |
| C-04 | プリセットビューにinvoiceがデフォルト設定 | E-03 Line 24-28 | ○ |
| C-05 | move_typeがOUT_INVOICEでフィルタ | E-03 Line 28 | ○ |
| C-06 | ヘッダーにCreateActionがある | E-03 Line 79-84 | ○ |
| C-07 | プリセットビュー一覧が存在 | E-03 Line 21-76 | ○ |
| C-08 | 支払待ちビューはNOT_PAID/PARTIALでフィルタ | E-03 Line 54-62 | ○ |
| C-09 | 期限超過ビューはinvoice_date_due < now()でフィルタ | E-03 Line 69-75 | ○ |
| C-10 | 画面名は顧客請求書一覧 | E-05 Line 194 | ○ |
| C-11 | カテゴリはInvoices（請求書） | E-05 Line 194 | ○ |
| C-12 | CustomerクラスターのInvoiceResourceを使用 | E-02 Line 23 | ○ |
| C-13 | InvoiceモデルはInvoice::class | E-02 Line 18 | ○ |
| C-14 | InvoiceResourceはBaseInvoiceResourceを継承 | E-02 Line 16 | ○ |
| C-15 | 権限による表示制御の詳細 | **根拠なし** | △ |
| C-16 | 転記済み請求書の削除制限 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 権限設定の詳細な定義ファイルが特定できていない
  - 候補：PolicyクラスまたはFilamentのauthorization設定
- 転記済み請求書の削除制限ロジックの確認が必要
  - 候補：DeleteActionのconditionまたはモデルのイベント

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的な画面構造と機能は明確
- 1: 中リスク - 転記済みデータの削除制御の確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] プリセットビューの動作確認（OUT_INVOICEフィルタ）
- [ ] 各プリセットビューのフィルタ条件確認
- [ ] 転記済み請求書の削除可否確認
- [ ] 権限設定の実装確認
