---
generated_at: 2025-12-26 18:35:00
metrics:
  claims_total: 14
  claims_with_evidence: 12
  claims_without_evidence: 2
confidence_derived: 0.86
---

# 根拠レポート：194-顧客請求書作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.86**
  - 根拠あり：12 / 14、根拠なし：2
- 優先レビュー（高）
  1. **フォーム項目の完全性**：InvoiceResourceのフォーム定義との整合性確認
  2. **顧客選択時の自動設定ロジック**：実際の動作確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/invoices/src/Filament/Clusters/Customer/Resources/InvoiceResource/Pages/CreateInvoice.php`
- E-02: `plugins/webkul/accounts/src/Filament/Resources/InvoiceResource/Pages/CreateInvoice.php`
- E-03: `plugins/webkul/accounts/src/Filament/Resources/InvoiceResource.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BaseCreateInvoiceを継承している | E-01 Line 5, 8 | ○ |
| C-02 | リソースはInvoiceResourceを使用 | E-01 Line 10 | ○ |
| C-03 | HasRepeaterColumnManagerトレイトを使用 | E-02 Line 14 | ○ |
| C-04 | 保存後は詳細画面へリダイレクト | E-02 Line 27-30 | ○ |
| C-05 | 成功通知を表示 | E-02 Line 32-38 | ○ |
| C-06 | move_typeにOUT_INVOICEを設定 | E-02 Line 42 | ○ |
| C-07 | dateに現在日時を設定 | E-02 Line 44 | ○ |
| C-08 | afterCreateでcomputeAccountMoveを実行 | E-02 Line 49-52 | ○ |
| C-09 | サブナビゲーションにクラスターコンポーネント | E-02 Line 16-23 | ○ |
| C-10 | 画面名は顧客請求書作成 | E-04 Line 195 | ○ |
| C-11 | URLは/invoices/customer/invoices/create | E-04 Line 195 | ○ |
| C-12 | フォーム項目はInvoiceResourceから継承 | E-03 | ○ |
| C-13 | 顧客選択時の自動設定ロジック詳細 | **根拠なし（推定）** | △ |
| C-14 | 商品選択時の自動設定ロジック詳細 | **根拠なし（推定）** | △ |

## 4) 不足情報（Unknown / Missing）
- 顧客選択時・商品選択時の自動設定ロジックの詳細確認
  - 候補：InvoiceResourceのフォーム定義内のafterStateUpdated
- フォーム項目の完全なリストはInvoiceResourceのform()メソッド参照が必要

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的な作成フローは明確
- 1: 中リスク - 自動設定ロジックの詳細確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] move_typeがOUT_INVOICEに正しく設定されることを確認
- [ ] 保存後の詳細画面へのリダイレクト動作確認
- [ ] 金額計算（computeAccountMove）の動作確認
- [ ] 明細行の追加・編集機能の動作確認
