---
generated_at: 2025-12-26 19:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：199-顧客一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **権限による表示制御**：具体的な権限設定の確認が必要
  2. **フォーム項目の詳細**：継承元との整合性確認

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/invoices/src/Filament/Clusters/Customer/Resources/PartnerResource/Pages/ListPartners.php`
- E-02: `plugins/webkul/invoices/src/Filament/Clusters/Customer/Resources/PartnerResource.php`
- E-03: `plugins/webkul/invoices/src/Filament/Clusters/Vendors/Resources/VendorResource.php`
- E-04: `plugins/webkul/partners/src/Filament/Resources/PartnerResource.php`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BaseListPartnersを継承している | E-01 Line 8 | ○ |
| C-02 | リソースはPartnerResourceを使用 | E-01 Line 12 | ○ |
| C-03 | タイトルは「Customer」 | E-01 Line 14-17 | ○ |
| C-04 | ヘッダーにCreateActionがある | E-01 Line 19-25 | ○ |
| C-05 | ラベルは「New Customer」 | E-01 Line 23 | ○ |
| C-06 | アイコンはheroicon-o-plus-circle | E-01 Line 24 | ○ |
| C-07 | PartnerResourceはVendorResourceを継承 | E-02 Line 15, 19 | ○ |
| C-08 | モデルはPartner::class | E-02 Line 21 | ○ |
| C-09 | Customerクラスターに属する | E-02 Line 29 | ○ |
| C-10 | navigationSortは6 | E-02 Line 25 | ○ |
| C-11 | ナビゲーションアイコンはheroicon-o-users | E-02 Line 27 | ○ |
| C-12 | sub_type = 'customer'でフィルタ | E-02 Line 52 | ○ |
| C-13 | カード形式のグリッドレイアウト | E-02 Line 45-50 | ○ |
| C-14 | サブナビゲーションにView, Edit, Contacts, Addresses, BankAccountsがある | E-02 Line 57-66 | ○ |
| C-15 | ページ定義がある | E-02 Line 68-79 | ○ |
| C-16 | カード形式のテーブル構造 | E-04 Line 315-600 | ○ |
| C-17 | 権限による表示制御の詳細 | **根拠なし** | △ |
| C-18 | フォーム項目の完全なリスト | **根拠なし（継承元参照要）** | △ |

## 4) 不足情報（Unknown / Missing）
- 権限設定の詳細な定義ファイルが特定できていない
  - 候補：PolicyクラスまたはFilamentのauthorization設定
- フォーム項目の完全なリストはVendorResourceのform()メソッド参照が必要
  - 候補：plugins/webkul/invoices/src/Filament/Clusters/Vendors/Resources/VendorResource.php

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的な画面構造と機能は明確
- 1: 中リスク - sub_type = 'customer'フィルタの動作確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] sub_type = 'customer'フィルタの動作確認
- [ ] カード形式レイアウトの表示確認
- [ ] 「New Customer」ボタンの動作確認
- [ ] サブナビゲーション（View, Edit, Contacts, Addresses, BankAccounts）の動作確認
- [ ] ソフトデリート/復元機能の動作確認
