---
generated_at: 2025-12-26 18:01:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：2-勘定科目作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `plugins/webkul/accounts/src/Filament/Resources/AccountResource/Pages/CreateAccount.php`
- E-02: `plugins/webkul/accounts/src/Filament/Resources/AccountResource.php`
- E-03: `plugins/webkul/accounts/src/Models/Account.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面クラスはCreateRecordを継承 | E-01 | ○ |
| C-02 | 保存成功後にViewAccountへリダイレクト | E-01 | ○ |
| C-03 | 成功通知を表示 | E-01 | ○ |
| C-04 | フォームにcode項目が存在 | E-02 | ○ |
| C-05 | フォームにname項目が存在 | E-02 | ○ |
| C-06 | フォームにaccount_type項目が存在 | E-02 | ○ |
| C-07 | account_typeがAccountType Enumを使用 | E-02 | ○ |
| C-08 | フォームにtaxes項目が存在 | E-02 | ○ |
| C-09 | taxesは科目タイプOFF_BALANCEで非表示 | E-02 | ○ |
| C-10 | フォームにtags項目が存在 | E-02 | ○ |
| C-11 | フォームにjournals項目が存在 | E-02 | ○ |
| C-12 | フォームにcurrency_id項目が存在 | E-02 | ○ |
| C-13 | フォームにdeprecated項目が存在 | E-02 | ○ |
| C-14 | フォームにreconcile項目が存在 | E-02 | ○ |
| C-15 | フォームにnon_trade項目が存在 | E-02 | ○ |
| C-16 | モデルのテーブルはaccounts_accounts | E-03 | ○ |
| C-17 | code, nameは必須項目 | E-02 | ○ |
| C-18 | URLは/accounts/accounts/create | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コード解析に基づく仕様のため、実装との整合性は高い

## 6) レビュアーチェックリスト（最小）
- [ ] バリデーションルールの確認（コードの一意性など）
- [ ] 関連テーブルへの保存処理の確認
- [ ] creator_idの自動設定処理の確認
