---
generated_at: 2025-12-26 19:05:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：200-税設定一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **権限による表示制御**：具体的な権限設定の確認が必要
  2. **ナビゲーショングループ**：実際の表示位置確認

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/invoices/src/Filament/Clusters/Configuration/Resources/TaxResource/Pages/ListTaxes.php`
- E-02: `plugins/webkul/invoices/src/Filament/Clusters/Configuration/Resources/TaxResource.php`
- E-03: `plugins/webkul/accounts/src/Filament/Resources/TaxResource.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BaseListTaxesを継承している | E-01 Line 5, 8 | ○ |
| C-02 | リソースはTaxResourceを使用 | E-01 Line 10 | ○ |
| C-03 | TaxResourceはBaseTaxResourceを継承 | E-02 Line 5, 15 | ○ |
| C-04 | モデルはTax::class | E-02 Line 17 | ○ |
| C-05 | Configurationクラスターに属する | E-02 Line 21 | ○ |
| C-06 | ナビゲーショングループがある | E-02 Line 33-36 | ○ |
| C-07 | ページ定義（index, create, view, edit, manage-distribution） | E-02 Line 38-48 | ○ |
| C-08 | テーブルにnameカラムがある | E-03 Line 126-129 | ○ |
| C-09 | テーブルにcompany.nameカラムがある | E-03 Line 130-132 | ○ |
| C-10 | テーブルにtaxGroup.nameカラムがある | E-03 Line 133-137 | ○ |
| C-11 | テーブルにtype_tax_useカラムがある | E-03 Line 142-145 | ○ |
| C-12 | テーブルにis_activeカラムがある（アイコン） | E-03 Line 171-174 | ○ |
| C-13 | グループ化オプションがある | E-03 Line 186-211 | ○ |
| C-14 | ActionGroupに編集・表示・削除がある | E-03 Line 212-234 | ○ |
| C-15 | BulkActionGroupに一括削除がある | E-03 Line 236-256 | ○ |
| C-16 | 並び替え機能がある | E-03 Line 258 | ○ |
| C-17 | フォームに必須項目がある（name, type_tax_use, amount_type, amount） | E-03 Line 60-83 | ○ |
| C-18 | 高度なオプションのフィールドセットがある | E-03 Line 85-110 | ○ |
| C-19 | 権限による表示制御の詳細 | **根拠なし** | △ |
| C-20 | 完全なURLパス | **根拠なし（推定）** | △ |

## 4) 不足情報（Unknown / Missing）
- 権限設定の詳細な定義ファイルが特定できていない
  - 候補：PolicyクラスまたはFilamentのauthorization設定
- 完全なURLパスの検証にはRouteServiceProviderの確認が必要
  - 候補：routes/web.php / Filament Panel Provider設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的な画面構造と機能は明確
- 1: 中リスク - 削除時のQueryException処理の動作確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] テーブルカラムの表示確認
- [ ] 並び替え機能の動作確認
- [ ] 削除時の関連データエラー処理確認
- [ ] 税グループのインライン作成機能確認
- [ ] 高度なオプションの表示・動作確認
- [ ] 請求書用/返金用配分管理画面への遷移確認
