---
generated_at: 2025-12-26 18:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：201-税グループ一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **画面遷移元の詳細**：ナビゲーション構造の確認が必要
  2. **権限管理の詳細設定**：FilamentShieldの具体的な権限設定

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/invoices/src/Filament/Clusters/Configuration/Resources/TaxGroupResource/Pages/ListTaxGroups.php`
- E-02: `plugins/webkul/invoices/src/Filament/Clusters/Configuration/Resources/TaxGroupResource.php`
- E-03: `plugins/webkul/accounts/src/Filament/Resources/TaxGroupResource/Pages/ListTaxGroups.php`
- E-04: `plugins/webkul/accounts/src/Filament/Resources/TaxGroupResource.php`
- E-05: `plugins/webkul/accounts/src/Models/TaxGroup.php`
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面はListTaxGroupsクラスで実装されている | E-01, E-03 | ○ |
| C-02 | AccountsモジュールのBaseクラスを継承 | E-01, E-02 | ○ |
| C-03 | テーブルカラム構成（company, country, createdBy, name, preceding_subtotal, created_at, updated_at） | E-04 | ○ |
| C-04 | グループ化機能（name, company, country, createdBy, created_at, updated_at） | E-04 | ○ |
| C-05 | CreateActionがヘッダーに存在 | E-03 | ○ |
| C-06 | ViewAction, EditAction, DeleteActionが行アクションとして存在 | E-04 | ○ |
| C-07 | DeleteBulkActionが一括アクションとして存在 | E-04 | ○ |
| C-08 | モデルはTaxGroupクラス | E-02, E-05 | ○ |
| C-09 | テーブル名はaccounts_tax_groups | E-05 | ○ |
| C-10 | Configurationクラスターに所属 | E-02 | ○ |
| C-11 | ルーティングは/invoices/configuration/tax-groups | E-02 | ○ |
| C-12 | 削除時にQueryExceptionをキャッチしてエラー通知 | E-04 | ○ |
| C-13 | 成功・エラー通知が実装されている | E-04 | ○ |
| C-14 | name項目は検索可能 | E-04 | ○ |
| C-15 | company, country, createdByはソート可能 | E-04 | ○ |
| C-16 | created_at, updated_atはデフォルト非表示（トグル可能） | E-04 | ○ |
| C-17 | 画面遷移元はダッシュボード、Invoicesモジュールトップ | **根拠なし** | △ |
| C-18 | FilamentShieldによる権限管理 | **根拠なし**（推定） | △ |

## 4) 不足情報（Unknown / Missing）
- 画面遷移元の具体的なナビゲーション構造
  - 候補：routes定義 / Clusterクラス / Panel定義
- FilamentShieldの具体的な権限設定
  - 候補：PolicyファイルまたはShield設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - テーブル構成、アクション定義は明確に確認済み
- 1: 中リスク - 権限管理の詳細設定は推定に基づく

## 6) レビュアーチェックリスト（最小）
- [ ] テーブルカラムの表示順序が実装と一致しているか確認
- [ ] グループ化機能の動作確認
- [ ] 削除時のエラーハンドリングが適切に動作するか確認
- [ ] 多言語リソースファイルの存在確認
