---
generated_at: 2025-12-26 18:32:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：202-支払条件一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **画面遷移元の詳細**：ナビゲーション構造の確認が必要
  2. **テーブル名の確認**：accounts_payment_termsテーブルの存在確認

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/invoices/src/Filament/Clusters/Configuration/Resources/PaymentTermResource/Pages/ListPaymentTerms.php`
- E-02: `plugins/webkul/invoices/src/Filament/Clusters/Configuration/Resources/PaymentTermResource.php`
- E-03: `plugins/webkul/accounts/src/Filament/Resources/PaymentTermResource.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面はListPaymentTermsクラスで実装されている | E-01 | ○ |
| C-02 | AccountsモジュールのBaseクラスを継承 | E-01, E-02 | ○ |
| C-03 | テーブルカラム構成（name, company.name, created_at, updated_at） | E-03 | ○ |
| C-04 | グループ化機能が存在（company.name, discount_days, early_pay_discountなど） | E-03 | ○ |
| C-05 | ViewAction, EditAction, RestoreAction, DeleteAction, ForceDeleteActionが行アクションとして存在 | E-03 | ○ |
| C-06 | DeleteBulkAction, ForceDeleteBulkAction, RestoreBulkActionが一括アクションとして存在 | E-03 | ○ |
| C-07 | Configurationクラスターに所属 | E-02 | ○ |
| C-08 | サブナビゲーション（View, Edit, ManagePaymentDueTerm）が存在 | E-02 | ○ |
| C-09 | ルーティングは/invoices/configuration/payment-terms | E-02 | ○ |
| C-10 | 成功・エラー通知が実装されている | E-03 | ○ |
| C-11 | name項目は検索・ソート可能 | E-03 | ○ |
| C-12 | company.name項目は検索・ソート可能 | E-03 | ○ |
| C-13 | created_at, updated_atはデフォルト非表示（トグル可能） | E-03 | ○ |
| C-14 | SubNavigationPositionはStartに設定 | E-03 | ○ |
| C-15 | SoftDeletes（論理削除）が使用されている | E-03 | ○ |
| C-16 | 画面番号は202 | E-04 | ○ |
| C-17 | 支払期限管理画面への遷移が可能 | E-02 | ○ |
| C-18 | ナビゲーションアイコンはheroicon-o-currency-dollar | E-03 | ○ |
| C-19 | テーブル名はaccounts_payment_terms | **根拠なし**（推定） | △ |
| C-20 | 画面遷移元はダッシュボード、Invoicesモジュールトップ | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- テーブル名の明示的な確認
  - 候補：PaymentTermモデルファイル / マイグレーションファイル
- 画面遷移元の具体的なナビゲーション構造
  - 候補：routes定義 / Clusterクラス

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - テーブル構成、アクション定義は明確に確認済み
- 0: 低リスク - SoftDeletes機能は明確に確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] テーブルカラムの表示順序が実装と一致しているか確認
- [ ] グループ化機能の動作確認
- [ ] 論理削除・復元機能の動作確認
- [ ] サブナビゲーションの遷移確認
- [ ] 多言語リソースファイルの存在確認
