---
generated_at: 2025-12-26 18:35:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：203-銀行口座一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **テーブル名の確認**：partners_bank_accountsテーブルの存在確認
  2. **画面遷移元の詳細**：ナビゲーション構造の確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/invoices/src/Filament/Clusters/Configuration/Resources/BankAccountResource/Pages/ListBankAccounts.php`
- E-02: `plugins/webkul/invoices/src/Filament/Clusters/Configuration/Resources/BankAccountResource.php`
- E-03: `plugins/webkul/accounts/src/Filament/Resources/BankAccountResource.php`
- E-04: `plugins/webkul/partners/src/Filament/Resources/BankAccountResource.php`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面はListBankAccountsクラスで実装されている | E-01 | ○ |
| C-02 | AccountsおよびPartnersモジュールのBaseクラスを継承 | E-02, E-03 | ○ |
| C-03 | テーブルカラム構成（account_number, bank.name, partner.name, deleted_at, created_at, updated_at） | E-04 | ○ |
| C-04 | can_send_moneyカラムがInvoicesモジュールでは除外されている | E-03 | ○ |
| C-05 | フォームからcan_send_moneyフィールドが除外されている | E-03 | ○ |
| C-06 | グループ化機能が存在（bank.name, can_send_money, created_at） | E-04 | ○ |
| C-07 | フィルター機能（can_send_money, bank_id, partner_id, creator_id） | E-04 | ○ |
| C-08 | EditAction, RestoreAction, DeleteAction, ForceDeleteActionが行アクションとして存在 | E-04 | ○ |
| C-09 | DeleteBulkAction, ForceDeleteBulkAction, RestoreBulkActionが一括アクションとして存在 | E-04 | ○ |
| C-10 | Configurationクラスターに所属 | E-02 | ○ |
| C-11 | ルーティングは/invoices/configuration/bank-accounts | E-02 | ○ |
| C-12 | 成功通知が実装されている | E-04 | ○ |
| C-13 | account_number項目は検索・ソート可能 | E-04 | ○ |
| C-14 | テーブルはreorderableColumns（カラム並び替え可能） | E-04 | ○ |
| C-15 | deleted_at, created_at, updated_atはデフォルト非表示（トグル可能） | E-04 | ○ |
| C-16 | フォーム項目（account_number, bank_id, partner_id）が存在 | E-04 | ○ |
| C-17 | account_numberはuniqueバリデーション | E-04 | ○ |
| C-18 | 銀行選択でwithTrashedを使用し論理削除された銀行も表示 | E-04 | ○ |
| C-19 | 論理削除された銀行はdisableOptionWhenで選択不可 | E-04 | ○ |
| C-20 | ナビゲーションアイコンはheroicon-o-banknotes | E-04 | ○ |
| C-21 | テーブル名はpartners_bank_accounts | **根拠なし**（推定） | △ |
| C-22 | 画面遷移元はダッシュボード、Invoicesモジュールトップ | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- テーブル名の明示的な確認
  - 候補：BankAccountモデルファイル / マイグレーションファイル
- 画面遷移元の具体的なナビゲーション構造
  - 候補：routes定義 / Clusterクラス

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - テーブル構成、アクション定義は明確に確認済み
- 0: 低リスク - Invoicesモジュール固有のカスタマイズは明確に確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] Invoicesモジュールでcan_send_moneyが適切に除外されているか確認
- [ ] フィルター機能の動作確認
- [ ] 銀行選択時の論理削除済みデータの表示・選択不可が正しく動作するか確認
- [ ] テーブルのカラム並び替えが動作するか確認
- [ ] 多言語リソースファイルの存在確認
