---
generated_at: 2025-12-26 18:38:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：204-インコタームズ一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **テーブル名の確認**：accounts_incotermsテーブルの存在確認
  2. **画面遷移元の詳細**：ナビゲーション構造の確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/invoices/src/Filament/Clusters/Configuration/Resources/IncoTermResource/Pages/ListIncoTerms.php`
- E-02: `plugins/webkul/invoices/src/Filament/Clusters/Configuration/Resources/IncoTermResource.php`
- E-03: `plugins/webkul/accounts/src/Filament/Resources/IncoTermResource.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面はListIncoTermsクラスで実装されている | E-01 | ○ |
| C-02 | AccountsモジュールのBaseクラスを継承 | E-01, E-02 | ○ |
| C-03 | テーブルカラム構成（code, name, createdBy.name） | E-03 | ○ |
| C-04 | フォーム項目（code, name, creator_id） | E-03 | ○ |
| C-05 | codeは最大3文字のバリデーション | E-03 | ○ |
| C-06 | creator_idはHidden項目で自動設定 | E-03 | ○ |
| C-07 | ViewAction, EditAction, DeleteAction, RestoreActionが行アクションとして存在 | E-03 | ○ |
| C-08 | DeleteBulkAction, ForceDeleteBulkAction, RestoreBulkActionが一括アクションとして存在 | E-03 | ○ |
| C-09 | Configurationクラスターに所属 | E-02 | ○ |
| C-10 | ルーティングは/invoices/configuration/incoterms | E-02 | ○ |
| C-11 | 成功通知が実装されている | E-03 | ○ |
| C-12 | code, name項目は検索・ソート可能 | E-03 | ○ |
| C-13 | createdBy.name項目はソート・検索可能 | E-03 | ○ |
| C-14 | ナビゲーションアイコンはheroicon-o-globe-alt | E-03 | ○ |
| C-15 | infolist（詳細表示）にcode, nameエントリが存在 | E-03 | ○ |
| C-16 | 画面番号は204 | E-04 | ○ |
| C-17 | テーブル名はaccounts_incoterms | **根拠なし**（推定） | △ |
| C-18 | 画面遷移元はダッシュボード、Invoicesモジュールトップ | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- テーブル名の明示的な確認
  - 候補：Incotermモデルファイル / マイグレーションファイル
- 画面遷移元の具体的なナビゲーション構造
  - 候補：routes定義 / Clusterクラス

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - テーブル構成、アクション定義は明確に確認済み
- 0: 低リスク - フォーム項目とバリデーションは明確に確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] codeフィールドの3文字制限が正しく動作するか確認
- [ ] creator_idの自動設定が正しく動作するか確認
- [ ] 詳細表示（infolist）の動作確認
- [ ] 多言語リソースファイルの存在確認
