---
generated_at: 2025-12-26 18:43:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：206-パートナー一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **ルーティングパスの確認**：実際のURL構成を確認
  2. **テーブル名の確認**：partners_partnersテーブルの存在確認

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/partners/src/Filament/Resources/PartnerResource/Pages/ListPartners.php`
- E-02: `plugins/webkul/partners/src/Filament/Resources/PartnerResource.php`
- E-03: `plugins/webkul/partners/src/Models/Partner.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面はListPartnersクラスで実装されている | E-01 | ○ |
| C-02 | HasTableViewsトレイトを使用（プリセットビュー） | E-01 | ○ |
| C-03 | プリセットビュー（individuals, companies, archived）が存在 | E-01 | ○ |
| C-04 | CreateActionがヘッダーに存在 | E-01 | ○ |
| C-05 | カードグリッド形式（contentGrid）で表示 | E-02 | ○ |
| C-06 | レスポンシブ設計（sm:1, md:2, xl:3, 2xl:4） | E-02 | ○ |
| C-07 | ページネーション（16, 32, 64, all） | E-02 | ○ |
| C-08 | Stack形式でカード内容を構成 | E-02 | ○ |
| C-09 | アバター、名前、親会社、職位、メール、電話、タグを表示 | E-02 | ○ |
| C-10 | タグは色付きバッジで表示 | E-02 | ○ |
| C-11 | QueryBuilderによる高度なフィルタリング | E-02 | ○ |
| C-12 | フィルターはモーダル形式（slideOver） | E-02 | ○ |
| C-13 | グループ化機能（account_type, parent, title, job_title, industry） | E-02 | ○ |
| C-14 | ViewAction, EditAction, DeleteAction, RestoreAction, ForceDeleteActionが存在 | E-02 | ○ |
| C-15 | DeleteBulkAction, RestoreBulkAction, ForceDeleteBulkActionが存在 | E-02 | ○ |
| C-16 | 論理削除時はView, Editアクションが非表示 | E-02 | ○ |
| C-17 | ForceDeleteActionでQueryExceptionをキャッチ | E-02 | ○ |
| C-18 | モデルはPartner | E-02 | ○ |
| C-19 | テーブル名はpartners_partners | E-03 | ○ |
| C-20 | SoftDeletes使用 | E-03 | ○ |
| C-21 | account_typeがAccountType::ADDRESSのレコードは除外 | E-02 | ○ |
| C-22 | デフォルトソートはcreated_at DESC | E-02 | ○ |
| C-23 | tagsリレーションを事前読み込み | E-02 | ○ |
| C-24 | 成功・エラー通知が実装されている | E-02 | ○ |
| C-25 | email表示は20文字制限 | E-02 | ○ |
| C-26 | phone表示は30文字制限 | E-02 | ○ |
| C-27 | ルーティングは/partners/partners | **根拠なし**（推定） | △ |
| C-28 | 画面遷移元はダッシュボード | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- ルーティングパスの明示的な確認
  - 候補：routes定義ファイル / Panel設定
- 画面遷移元の具体的なナビゲーション構造
  - 候補：Panel登録設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - カード表示構成、フィルター機能は明確に確認済み
- 0: 低リスク - アクション定義、例外処理は明確に確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] カードグリッド表示が正しくレスポンシブ動作するか確認
- [ ] プリセットビューの切り替えが正しく動作するか確認
- [ ] QueryBuilderフィルターの動作確認
- [ ] タグのバッジ表示（色付き）が正しく動作するか確認
- [ ] ForceDelete時の外部キー制約エラーハンドリング確認
- [ ] 多言語リソースファイルの存在確認
