---
generated_at: 2025-12-26 18:46:00
metrics:
  claims_total: 24
  claims_with_evidence: 22
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：207-パートナー作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：22 / 24、根拠なし：2
- 優先レビュー（高）
  1. **サブナビゲーションの動作確認**：クラスター依存の表示ロジック
  2. **ルーティングパスの確認**：実際のURL構成を確認

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/partners/src/Filament/Resources/PartnerResource/Pages/CreatePartner.php`
- E-02: `plugins/webkul/partners/src/Filament/Resources/PartnerResource.php`
- E-03: `plugins/webkul/partners/src/Models/Partner.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面はCreatePartnerクラスで実装されている | E-01 | ○ |
| C-02 | CreateRecordを継承 | E-01 | ○ |
| C-03 | 作成成功後にView画面にリダイレクト | E-01 | ○ |
| C-04 | 成功通知が実装されている | E-01 | ○ |
| C-05 | サブナビゲーションがクラスター依存で表示 | E-01 | ○ |
| C-06 | フォームにaccount_typeラジオボタンが存在 | E-02 | ○ |
| C-07 | account_typeのデフォルトはIndividual | E-02 | ○ |
| C-08 | ADDRESSタイプは選択肢から除外 | E-02 | ○ |
| C-09 | 名前フィールドは必須、最大255文字 | E-02 | ○ |
| C-10 | プレースホルダーがaccount_typeに応じて変化 | E-02 | ○ |
| C-11 | parent_idはIndividualの場合のみ表示 | E-02 | ○ |
| C-12 | parent_idはcompanyまたはsub_type=companyでフィルタリング | E-02 | ○ |
| C-13 | 親会社新規作成時にaccount_typeがCompanyに設定 | E-02 | ○ |
| C-14 | アバターはpartners/avatarディレクトリに保存 | E-02 | ○ |
| C-15 | アバターはpublic visibility | E-02 | ○ |
| C-16 | emailはuniqueバリデーション | E-02 | ○ |
| C-17 | 敬称の新規作成フォームが存在 | E-02 | ○ |
| C-18 | タグの新規作成フォーム（name, color）が存在 | E-02 | ○ |
| C-19 | 国選択で都道府県がフィルタリングされる | E-02 | ○ |
| C-20 | 都道府県の新規作成フォームが存在 | E-02 | ○ |
| C-21 | Sales/Purchaseタブが存在 | E-02 | ○ |
| C-22 | user_id（担当者）にヒントアイコンが存在 | E-02 | ○ |
| C-23 | ルーティングは/partners/partners/create | **根拠なし**（推定） | △ |
| C-24 | 画面番号は207 | E-04 | △ |

## 4) 不足情報（Unknown / Missing）
- ルーティングパスの明示的な確認
  - 候補：routes定義ファイル / Panel設定
- バリデーションメッセージの詳細
  - 候補：言語ファイル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - フォーム構成、バリデーションは明確に確認済み
- 0: 低リスク - 関連エンティティの新規作成機能は明確に確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] アカウントタイプ切り替え時の動的表示が正しく動作するか確認
- [ ] 所属会社新規作成時のaccount_type自動設定が正しく動作するか確認
- [ ] 国選択時の都道府県フィルタリングが正しく動作するか確認
- [ ] アバター画像のアップロード・保存が正しく動作するか確認
- [ ] 作成成功後のリダイレクトが正しく動作するか確認
- [ ] 多言語リソースファイルの存在確認
