---
generated_at: 2025-12-26 18:30:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：211-銀行口座管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **URL/ルーティング**：ルート定義ファイル未確認
  2. **権限による表示制御**：Policyファイル未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/partners/src/Filament/Resources/BankAccountResource/Pages/ManageBankAccounts.php`
- E-02: `plugins/webkul/partners/src/Filament/Resources/BankAccountResource.php`
- E-03: `plugins/webkul/partners/src/Models/BankAccount.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ManageRecords型の管理画面である | E-01 L13 `extends ManageRecords` | ○ |
| C-02 | 新規作成ボタンにCreateActionを使用 | E-01 L20-33 | ○ |
| C-03 | 「すべて」と「アーカイブ」の2つのタブが存在 | E-01 L37-47 `getTabs()` | ○ |
| C-04 | creator_idが自動設定される | E-01 L23-26 `mutateDataUsing` | ○ |
| C-05 | 入力項目：account_number、can_send_money、bank_id、partner_id | E-02 L50-83 `form()` | ○ |
| C-06 | テーブル列：account_number、bank.name、partner.name、can_send_money等 | E-02 L91-123 `table()` | ○ |
| C-07 | グループ化：bank.name、can_send_money、created_at | E-02 L125-132 | ○ |
| C-08 | フィルタ：can_send_money、bank_id、partner_id、creator_id | E-02 L134-151 | ○ |
| C-09 | アクション：Edit、Restore、Delete、ForceDelete | E-02 L153-182 | ○ |
| C-10 | 一括アクション：Restore、Delete、ForceDelete | E-02 L184-207 | ○ |
| C-11 | SoftDeletesを使用している | E-03 L8 `use SoftDeletes` | ○ |
| C-12 | テーブル名：partners_bank_accounts | E-03 L22 | ○ |
| C-13 | account_holder_nameがpartner.nameから自動設定 | E-03 L71-77 `boot()` | ○ |
| C-14 | 関連機能：FN-PAR-003 銀行口座管理 | E-05 L292-293 | ○ |
| C-15 | 画面種別：管理（Manage） | E-04 L212 | ○ |
| C-16 | 銀行選択時に削除済みも表示される | E-02 L61-69 `withTrashed()` | ○ |
| C-17 | URL: /partners/bank-accounts | **根拠なし** | △ |
| C-18 | 権限による表示制御がある | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- ルーティング定義ファイル（routes/*.php）が未確認のため、URLパスは推測
  - 候補：`routes/web.php` / Filamentプラグイン自動ルーティング / ServiceProviderでの登録
- PolicyまたはGate定義ファイルが未確認のため、権限制御の詳細は不明
  - 候補：`Policies/BankAccountPolicy.php` / FilamentResourceのcanメソッド

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 入出力項目、テーブル構造、アクション仕様は全てソースコードから確認済み
- 0: 低リスク - SoftDeletes実装によるアーカイブ機能も確認済み
- 1: 中リスク - URLパスはFilament標準に基づく推測であり、カスタマイズされている可能性あり

## 6) レビュアーチェックリスト（最小）
- [ ] URLパスが実際のルーティングと一致するか確認
- [ ] 権限制御の実装方式（Policy/Gateまたはその他）を確認
- [ ] 多言語ファイル（partners::filament/resources/bank-account）の内容を確認
