---
generated_at: 2025-12-26 18:32:00
metrics:
  claims_total: 12
  claims_with_evidence: 11
  claims_without_evidence: 1
confidence_derived: 0.92
---

# 根拠レポート：212-敬称管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：11 / 12、根拠なし：1
- 優先レビュー（高）
  1. **URL/ルーティング**：ルート定義ファイル未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/partners/src/Filament/Resources/TitleResource/Pages/ManageTitles.php`
- E-02: `plugins/webkul/partners/src/Filament/Resources/TitleResource.php`
- E-03: `plugins/webkul/partners/src/Models/Title.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ManageRecords型の管理画面である | E-01 L10 `extends ManageRecords` | ○ |
| C-02 | 入力項目：name、short_name | E-02 L26-33 `form()` | ○ |
| C-03 | nameは必須、最大255文字 | E-02 L27-29 | ○ |
| C-04 | short_nameは必須、最大255文字 | E-02 L30-33 | ○ |
| C-05 | テーブル列：name、short_name、created_at、updated_at | E-02 L40-54 `table()` | ○ |
| C-06 | nameとshort_nameは検索可能 | E-02 L42-46 `searchable()` | ○ |
| C-07 | アクション：Edit、Delete | E-02 L56-70 | ○ |
| C-08 | 一括アクション：DeleteBulkAction | E-02 L72-79 | ○ |
| C-09 | SoftDeletesは使用していない | E-03（SoftDeletes未使用） | ○ |
| C-10 | テーブル名：partners_titles | E-03 L20 | ○ |
| C-11 | fillable：name、short_name、creator_id | E-03 L27-31 | ○ |
| C-12 | URL: /partners/titles | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- ルーティング定義ファイル（routes/*.php）が未確認のため、URLパスは推測
  - Filament標準のルーティング規則に基づく推測
- 多言語リソースファイルの内容（partners::filament/resources/title）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 非常にシンプルな構造のため、リスクは低い
- 0: 低リスク - 入出力項目はソースコードから完全に確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] URLパスが実際のルーティングと一致するか確認
- [ ] 敬称削除時のパートナーへの影響（参照整合性）を確認
