---
generated_at: 2025-12-26 18:33:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：213-業種管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **URL/ルーティング**：ルート定義ファイル未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/partners/src/Filament/Resources/IndustryResource/Pages/ManageIndustries.php`
- E-02: `plugins/webkul/partners/src/Filament/Resources/IndustryResource.php`
- E-03: `plugins/webkul/partners/src/Models/Industry.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ManageRecords型の管理画面である | E-01 L10 `extends ManageRecords` | ○ |
| C-02 | 入力項目：name、description | E-02 L36-45 `form()` | ○ |
| C-03 | nameは必須、最大255文字、一意制約あり | E-02 L36-40 | ○ |
| C-04 | descriptionは必須、最大255文字、一意制約あり | E-02 L41-45 | ○ |
| C-05 | テーブル列：name、description | E-02 L52-60 `table()` | ○ |
| C-06 | nameとdescriptionは検索可能・ソート可能 | E-02 L53-60 | ○ |
| C-07 | アクション：Edit、Restore、Delete、ForceDelete | E-02 L62-91 | ○ |
| C-08 | 一括アクション：Restore、Delete、ForceDelete | E-02 L93-116 | ○ |
| C-09 | SoftDeletesを使用している | E-03 L8 `use SoftDeletes` | ○ |
| C-10 | テーブル名：partners_industries | E-03 L19 | ○ |
| C-11 | fillable：name、description、is_active、can_send_money、creator_id | E-03 L28-34 | ○ |
| C-12 | 削除済みレコードは編集アクションが非表示 | E-02 L64 `hidden(fn ($record) => $record->trashed())` | ○ |
| C-13 | タブ機能（すべて・アーカイブ）がある | E-01 L20-36 `getTabs()` | ○ |
| C-14 | URL: /partners/industries | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- ルーティング定義ファイル（routes/*.php）が未確認のため、URLパスは推測
  - Filament標準のルーティング規則に基づく推測
- 多言語リソースファイルの内容（partners::filament/resources/industry）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 入出力項目、アクション仕様は全てソースコードから確認済み
- 0: 低リスク - SoftDeletes実装によるアーカイブ機能も確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] URLパスが実際のルーティングと一致するか確認
- [ ] 業種削除時のパートナーへの影響（参照整合性）を確認
- [ ] can_send_money、is_activeカラムの用途を確認（フォームでは未使用）
