---
generated_at: 2025-12-26 18:35:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：214-銀行管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **URL/ルーティング**：ルート定義ファイル未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/partners/src/Filament/Resources/BankResource/Pages/ManageBanks.php`
- E-02: `plugins/webkul/partners/src/Filament/Resources/BankResource.php`
- E-03: `plugins/webkul/support/src/Models/Bank.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ManageRecords型の管理画面である | E-01 L10 `extends ManageRecords` | ○ |
| C-02 | フォームは基本情報と住所の2セクション構成 | E-02 L49-102 `form()` | ○ |
| C-03 | 入力項目：name、code、email、phone | E-02 L51-65 | ○ |
| C-04 | 入力項目：country_id、state_id、street1、street2、city、zip | E-02 L70-97 | ○ |
| C-05 | nameは必須 | E-02 L53 `required()` | ○ |
| C-06 | emailはメール形式バリデーション | E-02 L58-60 `email()` | ○ |
| C-07 | phoneは電話番号形式 | E-02 L61-63 `tel()` | ○ |
| C-08 | 国と都道府県/州は連動選択 | E-02 L73-85 `afterStateUpdated` | ○ |
| C-09 | creator_idはHiddenで自動設定 | E-02 L98-99 | ○ |
| C-10 | テーブル列：name、code、country.name等 | E-02 L107-133 `table()` | ○ |
| C-11 | nameとcodeは検索可能・ソート可能 | E-02 L109-116 | ○ |
| C-12 | グループ化：country.name、created_at | E-02 L135-140 | ○ |
| C-13 | アクション：Edit、Restore、Delete、ForceDelete | E-02 L142-171 | ○ |
| C-14 | 一括アクション：Restore、Delete、ForceDelete | E-02 L173-196 | ○ |
| C-15 | SoftDeletesを使用している | E-03 L8 `use SoftDeletes` | ○ |
| C-16 | 削除済みレコードは編集アクションが非表示 | E-02 L144 `hidden(fn ($record) => $record->trashed())` | ○ |
| C-17 | フォームは2カラムレイアウト | E-02 L66-67, L101 `columns(2)` | ○ |
| C-18 | URL: /partners/banks | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- ルーティング定義ファイル（routes/*.php）が未確認のため、URLパスは推測
  - Filament標準のルーティング規則に基づく推測
- 多言語リソースファイルの内容（partners::filament/resources/bank）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - フォーム構造、入出力項目、アクション仕様は全てソースコードから確認済み
- 0: 低リスク - SoftDeletes実装によるアーカイブ機能も確認済み
- 0: 低リスク - 国/都道府県連動ロジックも確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] URLパスが実際のルーティングと一致するか確認
- [ ] 銀行削除時の銀行口座への影響（参照整合性）を確認
- [ ] 実際のテーブル名（banks）がベースモデルの定義と一致するか確認
