---
generated_at: 2025-12-26 18:37:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：215-プラグイン一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **URL/ルーティング**：ルート定義ファイル未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/plugin-manager/src/Filament/Resources/PluginResource/Pages/ListPlugins.php`
- E-02: `plugins/webkul/plugin-manager/src/Filament/Resources/PluginResource.php`
- E-03: `plugins/webkul/support/src/Models/Plugin.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ListRecords型の一覧画面である | E-01 L10 `extends ListRecords` | ○ |
| C-02 | グリッドレイアウト（sm:1, md:2, lg:2, xl:3, 2xl:4） | E-02 L106-111 `contentGrid` | ○ |
| C-03 | カード表示項目：アイコン、名前、バージョン、概要、状態、依存数 | E-02 L54-104 `table()->columns()` | ○ |
| C-04 | プラグインアイコンはSVGから取得 | E-02 L57-60 `asset("svg/{$record->getPackage()->icon}.svg")` | ○ |
| C-05 | バージョンはデフォルト1.0.0 | E-02 L74 `default('1.0.0')` | ○ |
| C-06 | 概要は最大80文字で折り返し | E-02 L81-83 `limit(80)->wrap()` | ○ |
| C-07 | ViewActionでプラグイン詳細表示 | E-02 L115 `ViewAction::make()` | ○ |
| C-08 | installアクションが存在する | E-02 L127-165 `installAction()` | ○ |
| C-09 | uninstallアクションが存在する | E-02 L168-180 `uninstallAction()` | ○ |
| C-10 | インストール時にartisanコマンド実行 | E-02 L140-147 `exec($cmd)` | ○ |
| C-11 | インストール成功時にis_installed,is_activeをtrue | E-02 L149 | ○ |
| C-12 | アンインストール時にマイグレーションダウン実行 | E-02 L240-241 `runDownMigrations()` | ○ |
| C-13 | 除外プラグイン：accounts,products,payments,full-calendar | E-02 L372 `$excluded` | ○ |
| C-14 | コアプラグインは表示されない | E-02 L375-376 `$pkg->isCore` | ○ |
| C-15 | Infolist表示項目：name、version、is_installed、author、license等 | E-02 L286-338 `infolist()` | ○ |
| C-16 | 依存プラグイン表示（RepeatableEntry） | E-02 L341-367 | ○ |
| C-17 | 並び替え機能（reorderable） | E-02 L123 `reorderable('sort')` | ○ |
| C-18 | デフォルトソート：sort昇順 | E-02 L122 `defaultSort('sort', 'asc')` | ○ |
| C-19 | ページネーション：16,24,32 | E-02 L124 `paginated([16, 24, 32])` | ○ |
| C-20 | SortableTraitを使用 | E-03 L12 `use SortableTrait` | ○ |
| C-21 | アンインストールモーダルでテーブル影響表示 | E-02 L183-215 `buildUninstallModal()` | ○ |
| C-22 | URL: /plugin-manager/plugins | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- ルーティング定義ファイル（routes/*.php）が未確認のため、URLパスは推測
  - E-02 L385 `Pages\ListPlugins::route('/')` から親パスを推測
- 多言語リソースファイルの内容（plugin-manager::filament/resources/plugin）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - グリッドレイアウト、カード表示項目は全てソースコードから確認済み
- 0: 低リスク - インストール/アンインストール処理の詳細も確認済み
- 1: 中リスク - artisanコマンド実行（exec）はセキュリティ観点で要確認

## 6) レビュアーチェックリスト（最小）
- [ ] URLパスが実際のルーティングと一致するか確認
- [ ] exec()によるコマンド実行のセキュリティ対策を確認
- [ ] 依存プラグインの連鎖アンインストールの影響範囲を確認
