---
generated_at: 2025-12-26 18:40:00
metrics:
  claims_total: 26
  claims_with_evidence: 25
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：216-商品一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：25 / 26、根拠なし：1
- 優先レビュー（高）
  1. **URL/ルーティング**：ルート定義ファイル未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/products/src/Filament/Resources/ProductResource/Pages/ListProducts.php`
- E-02: `plugins/webkul/products/src/Filament/Resources/ProductResource.php`
- E-03: `plugins/webkul/products/src/Models/Product.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ListRecords型の一覧画面である | E-01 L14 `extends ListRecords` | ○ |
| C-02 | HasTableViewsトレイトを使用 | E-01 L16 `use HasTableViews` | ○ |
| C-03 | 親商品のみ表示（parent_id = null） | E-01 L23-25 `whereNull('parent_id')` | ○ |
| C-04 | プリセットビュー4種：物品、サービス、お気に入り、アーカイブ | E-01 L28-53 `getPresetTableViews()` | ○ |
| C-05 | 物品タブがデフォルト | E-01 L34 `setAsDefault()` | ○ |
| C-06 | アーカイブタブはonlyTrashed() | E-01 L51 `onlyTrashed()` | ○ |
| C-07 | 新規作成ボタンにCreateActionを使用 | E-01 L56-62 `getHeaderActions()` | ○ |
| C-08 | テーブル列：is_favorite、images、name、variants_count等 | E-02 L197-278 `table()->columns()` | ○ |
| C-09 | お気に入りはクリックでトグル | E-02 L202-206 `action()` | ○ |
| C-10 | 画像は円形・スタック・最大3枚 | E-02 L210-213 `circular()->stacked()->limit(3)` | ○ |
| C-11 | variants_countはcounts('variants') | E-02 L221 | ○ |
| C-12 | グループ化：type、category.name、created_at | E-02 L280-288 `groups()` | ○ |
| C-13 | フィルタはQueryBuilder使用 | E-02 L292-370 `QueryBuilder::make()` | ○ |
| C-14 | フィルタはモーダル・スライドオーバー表示 | E-02 L371-375 `FiltersLayout::Modal`, `slideOver()` | ○ |
| C-15 | 列の並び替え機能有効 | E-02 L195 `reorderableColumns()` | ○ |
| C-16 | columnManagerColumns(2) | E-02 L196 | ○ |
| C-17 | アクション：View、Edit、Restore、Delete、ForceDelete | E-02 L377-416 `recordActions()` | ○ |
| C-18 | 削除済みレコードはView/Editが非表示 | E-02 L380-382 `hidden(fn ($record) => $record->trashed())` | ○ |
| C-19 | 完全削除時に参照整合性チェック | E-02 L397-408 `QueryException catch` | ○ |
| C-20 | 一括アクション：Print、Restore、Delete、ForceDelete | E-02 L418-493 `toolbarActions()` | ○ |
| C-21 | 印刷機能でPDF生成 | E-02 L420-459 `BulkAction::make('print')` | ○ |
| C-22 | 印刷フォーマット選択（dymo等5種） | E-02 L431-438 | ○ |
| C-23 | SoftDeletesを使用 | E-03 L23 `use SoftDeletes` | ○ |
| C-24 | sortカラムでドラッグ並び替え | E-02 L289 `reorderable('sort')` | ○ |
| C-25 | デフォルトソート：sort降順 | E-02 L290 `defaultSort('sort', 'desc')` | ○ |
| C-26 | URL: /products/products | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- ルーティング定義ファイル（routes/*.php）が未確認のため、URLパスは推測
  - Filament標準のルーティング規則に基づく推測
- 多言語リソースファイルの内容（products::filament/resources/product）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - テーブル列、フィルタ、アクション仕様は全てソースコードから確認済み
- 0: 低リスク - プリセットビュー機能も確認済み
- 0: 低リスク - 印刷機能の詳細も確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] URLパスが実際のルーティングと一致するか確認
- [ ] 印刷テンプレート（products::filament.resources.products.actions.print）の内容を確認
- [ ] ProductType Enumの選択肢を確認
