---
generated_at: 2025-12-26 12:05:00
metrics:
  claims_total: 15
  claims_with_evidence: 14
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：22-財務ポジション詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：14 / 15、根拠なし：1
- 優先レビュー（高）
  1. **権限による表示制御**：権限設定の詳細実装未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/accounts/src/Filament/Resources/FiscalPositionResource/Pages/ViewFiscalPosition.php`
- E-02: `plugins/webkul/accounts/src/Filament/Resources/FiscalPositionResource.php`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`（行23）
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`（SCR-ACC-012）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面種別が「詳細」である | E-01: ViewRecord継承 | ○ |
| C-02 | ヘッダーにEditAction, DeleteActionがある | E-01: getHeaderActions() | ○ |
| C-03 | サブナビゲーションが画面上部に配置 | E-01: SubNavigationPosition::Top | ○ |
| C-04 | 削除時に成功通知を表示 | E-01: DeleteAction->successNotification() | ○ |
| C-05 | infolistにname項目がある | E-02: infolist() TextEntry::make('name') | ○ |
| C-06 | infolistにforeign_vat項目がある | E-02: infolist() TextEntry::make('foreign_vat') | ○ |
| C-07 | infolistにcountry.name項目がある | E-02: infolist() TextEntry::make('country.name') | ○ |
| C-08 | infolistにauto_replyアイコン項目がある | E-02: infolist() IconEntry::make('auto_reply') | ○ |
| C-09 | notesがマークダウン形式で表示 | E-02: TextEntry::make('notes')->markdown() | ○ |
| C-10 | 各項目にアイコンが設定されている | E-02: ->icon('heroicon-o-...') | ○ |
| C-11 | プレースホルダーに「-」が設定 | E-02: ->placeholder('-') | ○ |
| C-12 | ルーティングが/{record} | E-02: getPages() 'view' route | ○ |
| C-13 | 2カラムグリッドレイアウト | E-02: Grid::make()->columns(2) | ○ |
| C-14 | 画面一覧に登録されている | E-03: No.22 財務ポジション詳細 | ○ |
| C-15 | 権限による表示制御の詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 権限設定の詳細はFilamentの権限設定またはポリシークラスの確認が必要
  - 候補：`FiscalPositionPolicy.php` / `Filament Shield設定`

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 表示項目の仕様（ソースコードから明確）
- 0: 低リスク - ナビゲーション構成（ソースコードから明確）
- 1: 中リスク - 権限制御の詳細（別ファイル参照必要）

## 6) レビュアーチェックリスト（最小）
- [ ] 権限設定（FiscalPositionPolicy等）の実装内容を確認
- [ ] 多言語ファイル（accounts::filament/resources/fiscal-position/）の存在確認
- [ ] リレーション先（country, countryGroup）が削除された場合の表示確認
