---
generated_at: 2025-12-26 18:32:00
metrics:
  claims_total: 10
  claims_with_evidence: 8
  claims_without_evidence: 2
confidence_derived: 0.80
---

# 根拠レポート：223-価格表詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.80**
  - 根拠あり：8 / 10、根拠なし：2
- 優先レビュー（高）
  1. **Infolist定義**：表示項目の具体的構成が未定義
  2. **表示項目詳細**：具体的な表示レイアウト未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/products/src/Filament/Resources/PriceListResource/Pages/ViewPriceList.php`
- E-02: `plugins/webkul/products/src/Filament/Resources/PriceListResource.php`
- E-03: `plugins/webkul/products/src/Models/PriceList.php`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面種別はViewRecord | E-01 | ○ |
| C-02 | 対象リソースはPriceListResource | E-01, E-02 | ○ |
| C-03 | ヘッダーアクションにEditActionが存在 | E-01 | ○ |
| C-04 | モデルはPriceList | E-02, E-03 | ○ |
| C-05 | テーブル名はproducts_product_price_lists | E-03 | ○ |
| C-06 | 通貨リレーション（currency） | E-03 | ○ |
| C-07 | 会社リレーション（company） | E-03 | ○ |
| C-08 | ページルート: /{record} | E-02 | ○ |
| C-09 | 表示項目の具体的なレイアウト | **根拠なし** | △ |
| C-10 | Infolist定義 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- Infolist（詳細表示）の定義がPriceListResourceに存在しない
  - 候補：Filamentデフォルトの自動生成 / 別のコンフィグファイル / 動的生成
- 具体的な表示レイアウトはソースコードから読み取れない

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - Infolist定義がないため、実際の表示内容は実行時の動作確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] 詳細画面で価格表情報が正しく表示されるか確認
- [ ] EditActionで編集画面に遷移できるか確認
- [ ] リレーション先（通貨、会社、作成者）のデータが表示されるか確認
