---
generated_at: 2025-12-26 18:33:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：224-属性一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **ナビゲーション非表示設定**：shouldRegisterNavigation = falseの理由確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/products/src/Filament/Resources/AttributeResource/Pages/ListAttributes.php`
- E-02: `plugins/webkul/products/src/Filament/Resources/AttributeResource.php`
- E-03: `plugins/webkul/products/src/Models/Attribute.php`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面種別はListRecords | E-01 | ○ |
| C-02 | 対象リソースはAttributeResource | E-01, E-02 | ○ |
| C-03 | ヘッダーアクションにCreateActionが存在 | E-01 | ○ |
| C-04 | 「全件」タブと「アーカイブ済み」タブが存在 | E-01 | ○ |
| C-05 | タブに件数バッジが表示される | E-01 | ○ |
| C-06 | アーカイブ済みタブはonlyTrashedでフィルタ | E-01 | ○ |
| C-07 | モデルはAttribute | E-02, E-03 | ○ |
| C-08 | SoftDeletesトレイトを使用 | E-03 | ○ |
| C-09 | SortableTraitを使用 | E-03 | ○ |
| C-10 | テーブル名はproducts_attributes | E-03 | ○ |
| C-11 | 属性タイプはAttributeType Enumでキャスト | E-03 | ○ |
| C-12 | テーブルカラム：name（検索可能） | E-02 | ○ |
| C-13 | テーブルカラム：type（ソート可能） | E-02 | ○ |
| C-14 | テーブルカラム：created_at（トグル非表示デフォルト） | E-02 | ○ |
| C-15 | テーブルカラム：updated_at（トグル非表示デフォルト） | E-02 | ○ |
| C-16 | タイプによるフィルタが存在 | E-02 | ○ |
| C-17 | グループ化機能：type, created_at, updated_at | E-02 | ○ |
| C-18 | 行アクション：View, Edit, Restore, Delete, ForceDelete | E-02 | ○ |
| C-19 | 一括アクション：Restore, Delete, ForceDelete | E-02 | ○ |
| C-20 | 空状態でCreateActionを表示 | E-02 | ○ |
| C-21 | creator_id, company_idの自動設定（作成時） | E-01 | ○ |
| C-22 | メインナビゲーションからのアクセス方法 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- shouldRegisterNavigation = falseが設定されているため、メインナビゲーションには表示されない可能性
  - 候補：別のナビゲーション構成 / 親リソースからの遷移 / URLダイレクトアクセス

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソースコードからの情報が十分に取得できている

## 6) レビュアーチェックリスト（最小）
- [ ] 実際のナビゲーション経路を確認
- [ ] 全件タブとアーカイブ済みタブの切り替えが正常に動作するか確認
- [ ] ソフトデリート・復元・完全削除の動作確認
- [ ] タイプフィルタが正常に動作するか確認
