---
generated_at: 2025-12-26 18:36:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：227-属性詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/products/src/Filament/Resources/AttributeResource/Pages/ViewAttribute.php`
- E-02: `plugins/webkul/products/src/Filament/Resources/AttributeResource.php`
- E-03: `plugins/webkul/products/src/Models/Attribute.php`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面種別はViewRecord | E-01 | ○ |
| C-02 | 対象リソースはAttributeResource | E-01, E-02 | ○ |
| C-03 | ヘッダーアクションにEditActionが存在 | E-01 | ○ |
| C-04 | ヘッダーアクションにDeleteActionが存在 | E-01 | ○ |
| C-05 | 削除成功時に通知が表示される | E-01 | ○ |
| C-06 | Infolistは3カラムレイアウト | E-02 | ○ |
| C-07 | 左側グループは2カラム幅 | E-02 | ○ |
| C-08 | 右側グループは1カラム幅 | E-02 | ○ |
| C-09 | 基本情報セクションにname表示 | E-02 | ○ |
| C-10 | 属性名は太字・大サイズ表示 | E-02 | ○ |
| C-11 | 基本情報セクションにtype表示 | E-02 | ○ |
| C-12 | レコード情報セクションにcreator.name表示 | E-02 | ○ |
| C-13 | 作成者にユーザーアイコン表示 | E-02 | ○ |
| C-14 | レコード情報セクションにcreated_at表示 | E-02 | ○ |
| C-15 | created_atにカレンダーアイコン表示 | E-02 | ○ |
| C-16 | レコード情報セクションにupdated_at表示 | E-02 | ○ |
| C-17 | updated_atに時計アイコン表示 | E-02 | ○ |
| C-18 | レコード情報セクションはcollapsible | E-02 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコードからの根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] 詳細画面のレイアウトが設計通りに表示されるか確認
- [ ] EditActionで編集画面に遷移できるか確認
- [ ] DeleteActionで削除（ソフトデリート）が正常に動作するか確認
- [ ] レコード情報セクションの折り畳みが動作するか確認
