---
generated_at: 2025-12-26 12:10:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：23-財務ポジション税管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **権限による表示制御**：権限設定の詳細実装未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/accounts/src/Filament/Resources/FiscalPositionResource/Pages/ManageFiscalPositionTax.php`
- E-02: `plugins/webkul/accounts/src/Traits/FiscalPositionTax.php`
- E-03: `plugins/webkul/accounts/src/Filament/Resources/FiscalPositionResource.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`（行24）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面種別がManageRelatedRecords | E-01: ManageRelatedRecords継承 | ○ |
| C-02 | リレーション名がfiscalPositionTaxes | E-01: $relationship = 'fiscalPositionTaxes' | ○ |
| C-03 | ナビゲーションアイコンがheroicon-o-document | E-01: $navigationIcon | ○ |
| C-04 | サブナビゲーションが画面上部に配置 | E-01: SubNavigationPosition::Top | ○ |
| C-05 | FiscalPositionTaxトレイトを使用 | E-01: use FiscalPositionTax | ○ |
| C-06 | フォームにtax_source_id項目がある | E-02: Select::make('tax_source_id') | ○ |
| C-07 | フォームにtax_destination_id項目がある | E-02: Select::make('tax_destination_id') | ○ |
| C-08 | tax_source_idはリレーション選択 | E-02: ->relationship('taxSource', 'name') | ○ |
| C-09 | テーブルにtaxSource.nameカラムがある | E-02: TextColumn::make('taxSource.name') | ○ |
| C-10 | テーブルにtaxDestination.nameカラムがある | E-02: TextColumn::make('taxDestination.name') | ○ |
| C-11 | 行アクションにView/Edit/Deleteがある | E-02: recordActions配列 | ○ |
| C-12 | ヘッダーにCreateActionがある | E-02: headerActions配列 | ○ |
| C-13 | 作成時にcreator_idを自動設定 | E-02: mutateDataUsing | ○ |
| C-14 | 作成時にcompany_idを自動設定 | E-02: mutateDataUsing | ○ |
| C-15 | インフォリストに税表示項目がある | E-02: infolist() | ○ |
| C-16 | ルーティングがfiscal-position-tax | E-03: getPages() route | ○ |
| C-17 | 画面一覧に登録されている | E-04: No.23 財務ポジション税管理 | ○ |
| C-18 | 権限による表示制御の詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 権限設定の詳細はFilamentの権限設定またはポリシークラスの確認が必要
  - 候補：`FiscalPositionPolicy.php` / `Filament Shield設定`
- fiscal_position_taxesテーブルのマイグレーション定義

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - フォーム・テーブル項目（ソースコードから明確）
- 0: 低リスク - 自動設定項目（ソースコードから明確）
- 1: 中リスク - 権限制御の詳細（別ファイル参照必要）

## 6) レビュアーチェックリスト（最小）
- [ ] 権限設定の実装内容を確認
- [ ] 多言語ファイル（accounts::traits/fiscal-position-tax）の存在確認
- [ ] fiscal_position_taxesテーブルのマイグレーション定義との整合性確認
- [ ] 税マスタ（taxes）テーブルとのリレーション確認
