---
generated_at: 2025-12-26 15:35:00
metrics:
  claims_total: 28
  claims_with_evidence: 27
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：233-プロジェクト一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：27 / 28、根拠なし：1
- 優先レビュー（高）
  1. **お気に入りテーブル名**：マイグレーションファイルでの正式名称確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/projects/src/Filament/Resources/ProjectResource/Pages/ListProjects.php`
- E-02: `plugins/webkul/projects/src/Filament/Resources/ProjectResource.php`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-04: `docs/code-to-docs/画面遷移図.md`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ListRecordsクラスを継承している | E-01 Line 13 | ○ |
| C-02 | HasTableViewsトレイトを使用 | E-01 Line 15 | ○ |
| C-03 | マイプロジェクトのフィルタ条件 | E-01 Lines 22-25 | ○ |
| C-04 | お気に入りプロジェクトのフィルタ条件 | E-01 Lines 27-34 | ○ |
| C-05 | 未割当プロジェクトのフィルタ条件 | E-01 Lines 36-39 | ○ |
| C-06 | アーカイブ済みのフィルタ条件 | E-01 Lines 41-46 | ○ |
| C-07 | CreateActionがヘッダーに存在 | E-01 Lines 50-55 | ○ |
| C-08 | URLスラッグは project/projects | E-02 Line 75 | ○ |
| C-09 | カード形式のグリッドレイアウト | E-02 Lines 479-484 | ○ |
| C-10 | レスポンシブグリッド（sm=1, md=2, xl=3, 2xl=4） | E-02 Lines 479-484 | ○ |
| C-11 | Stackを使用したカード表示 | E-02 Lines 230-295 | ○ |
| C-12 | お気に入りトグルアクション | E-02 Lines 411-422 | ○ |
| C-13 | タスクボタンでManageTasksへ遷移 | E-02 Lines 423-429 | ○ |
| C-14 | マイルストーンボタンでManageMilestonesへ遷移 | E-02 Lines 430-438 | ○ |
| C-15 | EditAction, RestoreAction, DeleteAction, ForceDeleteActionが存在 | E-02 Lines 440-473 | ○ |
| C-16 | 完全削除時にQueryExceptionをキャッチ | E-02 Lines 457-471 | ○ |
| C-17 | QueryBuilderによるフィルタ | E-02 Lines 310-403 | ○ |
| C-18 | フィルタはモーダル形式 | E-02 Line 404 | ○ |
| C-19 | フィルタはスライドオーバー | E-02 Lines 405-408 | ○ |
| C-20 | プロジェクト名は太字で表示 | E-02 Line 233 | ○ |
| C-21 | 顧客名はアイコン付きで表示 | E-02 Lines 239-242 | ○ |
| C-22 | 期間表示の形式 | E-02 Lines 256-258 | ○ |
| C-23 | 残時間のバッジ表示と色分け | E-02 Lines 263-268 | ○ |
| C-24 | タグのバッジ表示（各タグの色） | E-02 Lines 279-291 | ○ |
| C-25 | HasCustomFieldsトレイトを使用 | E-02 Line 71 | ○ |
| C-26 | TaskSettingsでマイルストーン表示制御 | E-02 Line 437 | ○ |
| C-27 | TimeSettingsでタイムシート関連表示制御 | E-02 Line 270 | ○ |
| C-28 | お気に入りテーブル名はprojects_user_project_favorites | E-01 Line 33 | ○ |

## 4) 不足情報（Unknown / Missing）
- **テーブル名の正式確認**：マイグレーションファイルでの検証
  - 候補：database/migrations/ 配下のマイグレーションファイル

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 画面構成・機能は正確に把握されている

## 6) レビュアーチェックリスト（最小）
- [ ] お気に入り機能が正しく動作するか確認
- [ ] グリッドレイアウトのレスポンシブ表示が適切か確認
- [ ] フィルタ条件が要件を満たしているか確認
