---
generated_at: 2025-12-26 15:42:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：236-プロジェクト詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）：なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/projects/src/Filament/Resources/ProjectResource/Pages/ViewProject.php`
- E-02: `plugins/webkul/projects/src/Filament/Resources/ProjectResource.php`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ViewRecordクラスを継承している | E-01 Line 12 | ○ |
| C-02 | ヘッダーにChatterActionとDeleteActionがある | E-01 Lines 16-29 | ○ |
| C-03 | ChatterActionにリソースとアクティビティプランを設定 | E-01 Lines 19-21 | ○ |
| C-04 | DeleteActionに成功通知が設定されている | E-01 Lines 22-28 | ○ |
| C-05 | アクティビティプランはplugin='projects'でフィルタ | E-01 Lines 31-34 | ○ |
| C-06 | infolistは3カラムレイアウト | E-02 Line 647 | ○ |
| C-07 | 一般情報セクションにname, descriptionを表示 | E-02 Lines 502-510 | ○ |
| C-08 | nameは大サイズ・太字で表示 | E-02 Lines 503-506 | ○ |
| C-09 | descriptionはマークダウン形式で表示 | E-02 Lines 508-510 | ○ |
| C-10 | 追加情報セクションは2カラムグリッド | E-02 Line 515 | ○ |
| C-11 | user.name, partner.name, planned_date, allocated_hours, remaining_hours, stage.name, tags.nameを表示 | E-02 Lines 516-572 | ○ |
| C-12 | remaining_hoursは負値でdanger、正値でsuccessカラー | E-02 Line 549 | ○ |
| C-13 | stage.nameはバッジ形式で表示 | E-02 Lines 552-556 | ○ |
| C-14 | tagsは色付きバッジで表示 | E-02 Lines 558-571 | ○ |
| C-15 | 統計情報セクションにtasks_countとmilestones_completionを表示 | E-02 Lines 576-600 | ○ |
| C-16 | tasks_countはManageTasksへのリンク | E-02 Line 586 | ○ |
| C-17 | milestones_completionはManageMilestonesへのリンク | E-02 Line 599 | ○ |
| C-18 | レコード情報セクションにcreated_at, creator.name, updated_atを表示 | E-02 Lines 608-622 | ○ |
| C-19 | 設定セクションにvisibility, allow_timesheets, allow_milestonesを表示 | E-02 Lines 625-642 | ○ |
| C-20 | visibilityはバッジ形式でアイコン・色付き | E-02 Lines 627-632 | ○ |
| C-21 | サブナビゲーションはSubNavigationPosition::Top | E-02 Line 77 | ○ |
| C-22 | サブナビゲーションにViewProject, EditProject, ManageTasks, ManageMilestones | E-02 Lines 660-668 | ○ |

## 4) 不足情報（Unknown / Missing）
なし - 全ての主張に根拠が確認されました。

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全ての主張にソースコードの根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] 統計情報のリンクが正しく動作するか確認
- [ ] 可視性のアイコン・色表示が正しいか確認
- [ ] カスタムフィールドの表示が正常か確認
