---
generated_at: 2025-12-26 15:50:00
metrics:
  claims_total: 26
  claims_with_evidence: 26
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：239-タスク一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：26 / 26、根拠なし：0
- 優先レビュー（高）：なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/projects/src/Filament/Resources/TaskResource/Pages/ListTasks.php`
- E-02: `plugins/webkul/projects/src/Filament/Resources/TaskResource.php`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ListRecordsクラスを継承している | E-01 Line 16 | ○ |
| C-02 | HasTableViewsトレイトを使用 | E-01 Line 18 | ○ |
| C-03 | StatsOverviewWidgetをヘッダーウィジェットとして表示 | E-01 Lines 22-27 | ○ |
| C-04 | CreateActionがヘッダーに存在 | E-01 Lines 102-108 | ○ |
| C-05 | parent_id IS NULLでフィルタ | E-01 Lines 29-34 | ○ |
| C-06 | プリセットビュー定義がある | E-01 Lines 37-99 | ○ |
| C-07 | オープンタスクのフィルタ条件（デフォルト） | E-01 Lines 40-47 | ○ |
| C-08 | マイタスクのフィルタ条件 | E-01 Lines 49-57 | ○ |
| C-09 | 未割当タスクのフィルタ条件 | E-01 Lines 59-64 | ○ |
| C-10 | プライベートタスクのフィルタ条件 | E-01 Lines 66-71 | ○ |
| C-11 | フォロー中タスクのフィルタ条件 | E-01 Lines 73-79 | ○ |
| C-12 | クローズドタスクのフィルタ条件 | E-01 Lines 81-86 | ○ |
| C-13 | スター付きタスクのフィルタ条件 | E-01 Lines 88-92 | ○ |
| C-14 | アーカイブ済みタスクのフィルタ条件 | E-01 Lines 94-99 | ○ |
| C-15 | priorityはアイコン表示でクリックトグル可 | E-02 Lines 279-287 | ○ |
| C-16 | stateはアイコン表示でクリックでモーダル表示 | E-02 Lines 288-312 | ○ |
| C-17 | 列管理機能（columnManagerColumns: 2） | E-02 Line 272 | ○ |
| C-18 | 列の並び替え機能対応 | E-02 Line 271 | ○ |
| C-19 | progressはプログレスバー表示 | E-02 Lines 409-414 | ○ |
| C-20 | タグは色付きバッジ表示 | E-02 Lines 419-431 | ○ |
| C-21 | 時間関連列にサマリー（Sum）がある | E-02 Lines 351-407 | ○ |
| C-22 | ActionGroupで行アクションをグループ化 | E-02 Lines 603-629 | ○ |
| C-23 | BulkActionGroupで一括アクションをグループ化 | E-02 Lines 631-654 | ○ |
| C-24 | フィルタはQueryBuilderでモーダル形式 | E-02 Lines 458-596, 600-601 | ○ |
| C-25 | HasCustomFieldsトレイトを使用 | E-02 Line 79 | ○ |
| C-26 | URLスラッグは project/tasks | E-02 Line 83 | ○ |

## 4) 不足情報（Unknown / Missing）
なし - 全ての主張に根拠が確認されました。

## 5) リスクフラグ（レビュー観点）
- **0: 低リスク** - 全ての主張にソースコードの根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] 統計ウィジェットが正しく表示されるか確認
- [ ] プリセットビューの切替が正しく動作するか確認
- [ ] 優先度・状態のインライン更新が正しく動作するか確認
