---
generated_at: 2025-12-26 12:15:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：24-インコタームズ一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **権限による表示制御**：権限設定の詳細実装未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/accounts/src/Filament/Resources/IncoTermResource/Pages/ListIncoTerms.php`
- E-02: `plugins/webkul/accounts/src/Filament/Resources/IncoTermResource.php`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`（行25）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面種別がListRecords | E-01: ListRecords継承 | ○ |
| C-02 | ヘッダーにCreateActionがある | E-01: getHeaderActions() | ○ |
| C-03 | 作成アイコンがheroicon-o-plus-circle | E-01: ->icon('heroicon-o-plus-circle') | ○ |
| C-04 | モデルがIncoterm | E-02: $model = Incoterm::class | ○ |
| C-05 | ナビゲーションアイコンがheroicon-o-globe-alt | E-02: $navigationIcon | ○ |
| C-06 | フォームにcreator_id隠しフィールドがある | E-02: Hidden::make('creator_id') | ○ |
| C-07 | フォームにcode項目がある | E-02: TextInput::make('code') | ○ |
| C-08 | codeのmaxLengthが3 | E-02: ->maxLength(3) | ○ |
| C-09 | フォームにname項目がある | E-02: TextInput::make('name') | ○ |
| C-10 | テーブルにcodeカラムがある | E-02: TextColumn::make('code') | ○ |
| C-11 | テーブルにnameカラムがある | E-02: TextColumn::make('name') | ○ |
| C-12 | テーブルにcreatedBy.nameカラムがある | E-02: TextColumn::make('createdBy.name') | ○ |
| C-13 | 行アクションにView/Edit/Delete/Restoreがある | E-02: recordActions配列 | ○ |
| C-14 | 一括アクションに削除/完全削除/復元がある | E-02: toolbarActions BulkActionGroup | ○ |
| C-15 | 成功通知が設定されている | E-02: successNotification各所 | ○ |
| C-16 | shouldRegisterNavigationがfalse | E-02: $shouldRegisterNavigation = false | ○ |
| C-17 | ルーティングが/ (index) | E-02: getPages() 'index' route | ○ |
| C-18 | インフォリストにcode, name項目がある | E-02: infolist() | ○ |
| C-19 | 画面一覧に登録されている | E-03: No.24 インコタームズ一覧 | ○ |
| C-20 | 権限による表示制御の詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 権限設定の詳細はFilamentの権限設定またはポリシークラスの確認が必要
  - 候補：`IncotermPolicy.php` / `Filament Shield設定`
- incotermsテーブルのマイグレーション定義（ソフトデリート対応の確認）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - フォーム・テーブル項目（ソースコードから明確）
- 0: 低リスク - バリデーション設定（ソースコードから明確）
- 1: 中リスク - 権限制御の詳細（別ファイル参照必要）

## 6) レビュアーチェックリスト（最小）
- [ ] 権限設定の実装内容を確認
- [ ] 多言語ファイル（accounts::filament/resources/incoterm）の存在確認
- [ ] incotermsテーブルのマイグレーション定義との整合性確認
- [ ] ソフトデリート対応（SoftDeletes trait）の確認
