---
generated_at: 2025-12-26 18:35:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：243-サブタスク管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張にソースコード根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/projects/src/Filament/Resources/TaskResource/Pages/ManageSubTasks.php`
- E-02: `plugins/webkul/projects/src/Filament/Resources/TaskResource.php`
- E-03: `plugins/webkul/projects/src/Models/Task.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ManageRelatedRecordsクラスを継承 | E-01 L24 | ○ |
| C-02 | relationshipはsubTasks | E-01 L28 | ○ |
| C-03 | ナビゲーションアイコンはclipboard-document-list | E-01 L30 | ○ |
| C-04 | フォームはTaskResource::form()を使用 | E-01 L37-39 | ○ |
| C-05 | テーブルはTaskResource::table()を継承 | E-01 L42-44 | ○ |
| C-06 | TrashedFilterが使用されている | E-01 L45-47 | ○ |
| C-07 | フィルタレイアウトはDropdown | E-01 L48 | ○ |
| C-08 | グループ機能は空配列で無効化 | E-01 L51 | ○ |
| C-09 | CreateActionがヘッダーに存在 | E-01 L52-77 | ○ |
| C-10 | 作成時に親タスクのproject_idを継承 | E-01 L60 | ○ |
| C-11 | 作成時に親タスクのmilestone_idを継承 | E-01 L61 | ○ |
| C-12 | 作成時に親タスクのpartner_idを継承 | E-01 L62 | ○ |
| C-13 | 作成時に親タスクのusersを継承 | E-01 L63 | ○ |
| C-14 | 作成時にcreator_idをAuth::id()で設定 | E-01 L66-70 | ○ |
| C-15 | モーダル幅は6xl | E-01 L71 | ○ |
| C-16 | ViewActionはTaskResourceのURLに遷移 | E-01 L81-83 | ○ |
| C-17 | EditActionはTaskResourceのURLに遷移 | E-01 L84-86 | ○ |
| C-18 | 論理削除レコードではView/Editが非表示 | E-01 L83, L86 | ○ |
| C-19 | RestoreActionが存在 | E-01 L87-93 | ○ |
| C-20 | DeleteActionが存在 | E-01 L94-100 | ○ |
| C-21 | ForceDeleteActionが存在 | E-01 L101-107 | ○ |
| C-22 | InfolistはTaskResource::infolist()を使用 | E-01 L112-115 | ○ |
| C-23 | URLは/project/tasks/{record}/sub-tasks | E-02 L892 | ○ |
| C-24 | TaskモデルにsubTasksリレーション（parent_id） | E-03 L118-121 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認可能
- ManageSubTasks.phpで実装詳細が完全に確認できる

## 6) レビュアーチェックリスト（最小）
- [ ] 親タスクの情報が正しく継承されることを確認
- [ ] 論理削除レコードのアクション表示制御を確認
- [ ] モーダルの表示サイズを確認
