---
generated_at: 2025-12-26 18:38:00
metrics:
  claims_total: 26
  claims_with_evidence: 26
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：244-タイムシート管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：26 / 26、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張にソースコード根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/projects/src/Filament/Resources/TaskResource/Pages/ManageTimesheets.php`
- E-02: `plugins/webkul/projects/src/Filament/Resources/TaskResource.php`
- E-03: `plugins/webkul/projects/src/Models/Task.php`
- E-04: `plugins/webkul/projects/src/Settings/TimeSettings.php`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ManageRelatedRecordsクラスを継承 | E-01 L22 | ○ |
| C-02 | relationshipはtimesheets | E-01 L26 | ○ |
| C-03 | ナビゲーションアイコンはclock | E-01 L28 | ○ |
| C-04 | canAccessでTimeSettings.enable_timesheetsをチェック | E-01 L46 | ○ |
| C-05 | canAccessでproject.allow_timesheetsをチェック | E-01 L50-54 | ○ |
| C-06 | Hiddenフィールドでtype='projects' | E-01 L61-62 | ○ |
| C-07 | DatePickerでdate入力 | E-01 L63-66 | ○ |
| C-08 | Selectでuser_id入力（userリレーション） | E-01 L67-72 | ○ |
| C-09 | TextInputでname入力 | E-01 L73-74 | ○ |
| C-10 | TextInputでunit_amount入力（0-99999999999） | E-01 L75-81 | ○ |
| C-11 | テーブルに日付列（Y-m-d形式） | E-01 L91-93 | ○ |
| C-12 | テーブルにuser.name列 | E-01 L94-95 | ○ |
| C-13 | テーブルにname列 | E-01 L96-97 | ○ |
| C-14 | unit_amountはSum集計あり | E-01 L98-144 | ○ |
| C-15 | サブタスク使用時間はsubtask_effective_hoursから | E-01 L117-119 | ○ |
| C-16 | 総使用時間はtotal_hours_spentから | E-01 L125-127 | ○ |
| C-17 | 残り時間はremaining_hoursから | E-01 L134-138 | ○ |
| C-18 | 残り時間はallocated_hours設定時のみ表示 | E-01 L143 | ○ |
| C-19 | CreateActionがヘッダーに存在 | E-01 L146-166 | ○ |
| C-20 | creator_idをAuth::id()で設定 | E-01 L151 | ○ |
| C-21 | project_idを親タスクから設定 | E-01 L155 | ○ |
| C-22 | partner_idを親タスクまたはプロジェクトから設定 | E-01 L157 | ○ |
| C-23 | EditActionが行アクションに存在 | E-01 L168-175 | ○ |
| C-24 | DeleteActionが行アクションに存在 | E-01 L176-182 | ○ |
| C-25 | ページネーション無効 | E-01 L184 | ○ |
| C-26 | URLは/project/tasks/{record}/timesheets | E-02 L891 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認可能
- ManageTimesheets.phpで実装詳細が完全に確認できる

## 6) レビュアーチェックリスト（最小）
- [ ] タイムシート設定無効時のアクセス制御を確認
- [ ] プロジェクトのタイムシート許可フラグ動作を確認
- [ ] 時間のサマリー計算が正しいことを確認
- [ ] 残り時間の条件付き表示を確認
