---
generated_at: 2025-12-26 18:41:00
metrics:
  claims_total: 25
  claims_with_evidence: 25
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：245-タスクステージ管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：25 / 25、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張にソースコード根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/projects/src/Filament/Clusters/Configurations/Resources/TaskStageResource/Pages/ManageTaskStages.php`
- E-02: `plugins/webkul/projects/src/Filament/Clusters/Configurations/Resources/TaskStageResource.php`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ManageRecordsクラスを継承 | E-01 L13 | ○ |
| C-02 | CreateActionがヘッダーに存在 | E-01 L17-36 | ○ |
| C-03 | creator_idをAuth::id()で設定 | E-01 L23-26 | ○ |
| C-04 | タブ「all」と「archived」が存在 | E-01 L39-49 | ○ |
| C-05 | allタブにTaskStage::count()でバッジ | E-01 L42-43 | ○ |
| C-06 | archivedタブにonlyTrashed().count()でバッジ | E-01 L44-48 | ○ |
| C-07 | Configurationsクラスター内に配置 | E-02 L40 | ○ |
| C-08 | ナビゲーションアイコンはrectangle-stack | E-02 L36 | ○ |
| C-09 | ナビゲーション順序は2 | E-02 L38 | ○ |
| C-10 | nameフィールドは必須・最大255文字 | E-02 L51-54 | ○ |
| C-11 | project_idフィールドは必須・検索可能 | E-02 L55-69 | ○ |
| C-12 | 論理削除済みプロジェクトも表示（選択不可） | E-02 L57-65 | ○ |
| C-13 | テーブルにnameカラム（検索・ソート可能） | E-02 L78-81 | ○ |
| C-14 | テーブルにproject.nameカラム | E-02 L82-85 | ○ |
| C-15 | SelectFilterでproject_id絞り込み | E-02 L87-93 | ○ |
| C-16 | グループ化でproject.nameと作成日 | E-02 L95-100 | ○ |
| C-17 | reorderable('sort')で並べ替え | E-02 L102 | ○ |
| C-18 | defaultSort('sort', 'desc') | E-02 L103 | ○ |
| C-19 | EditActionが存在（削除レコードで非表示） | E-02 L104-112 | ○ |
| C-20 | RestoreActionが存在 | E-02 L113-119 | ○ |
| C-21 | DeleteActionが存在 | E-02 L120-126 | ○ |
| C-22 | ForceDeleteActionが存在 | E-02 L127-143 | ○ |
| C-23 | ForceDeleteでQueryException処理 | E-02 L129-142 | ○ |
| C-24 | BulkActionGroupで一括操作 | E-02 L145-179 | ○ |
| C-25 | URLは/settings/projects/task-stages | E-02 L186 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認可能
- TaskStageResource.phpとManageTaskStages.phpで完全に確認できる

## 6) レビュアーチェックリスト（最小）
- [ ] タブ切り替え時のフィルタ動作を確認
- [ ] ドラッグ&ドロップでの順序変更を確認
- [ ] 関連タスクがある場合の完全削除エラーを確認
