---
generated_at: 2025-12-26 18:44:00
metrics:
  claims_total: 23
  claims_with_evidence: 23
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：246-プロジェクトステージ管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：23 / 23、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張にソースコード根拠あり）

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/projects/src/Filament/Clusters/Configurations/Resources/ProjectStageResource/Pages/ManageProjectStages.php`
- E-02: `plugins/webkul/projects/src/Filament/Clusters/Configurations/Resources/ProjectStageResource.php`
- E-03: `plugins/webkul/projects/src/Settings/TaskSettings.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ManageRecordsクラスを継承 | E-01 L13 | ○ |
| C-02 | CreateActionがヘッダーに存在 | E-01 L17-34 | ○ |
| C-03 | creator_idをAuth::id()で設定 | E-01 L22-25 | ○ |
| C-04 | タブ「all」と「archived」が存在 | E-01 L37-48 | ○ |
| C-05 | allタブにProjectStage::count()でバッジ | E-01 L40-41 | ○ |
| C-06 | archivedタブにonlyTrashed().count()でバッジ | E-01 L42-47 | ○ |
| C-07 | Configurationsクラスター内に配置 | E-02 L37 | ○ |
| C-08 | ナビゲーションアイコンはsquares-2x2 | E-02 L33 | ○ |
| C-09 | ナビゲーション順序は1 | E-02 L35 | ○ |
| C-10 | isDiscovered()でenable_project_stagesチェック | E-02 L44-51 | ○ |
| C-11 | コンソール実行時は常にtrue | E-02 L46-48 | ○ |
| C-12 | nameフィールドは必須・最大255文字・一意 | E-02 L57-61 | ○ |
| C-13 | テーブルにnameカラム（検索・ソート可能） | E-02 L70-73 | ○ |
| C-14 | グループ化でcreated_at | E-02 L75-78 | ○ |
| C-15 | reorderable('sort')で並べ替え | E-02 L80 | ○ |
| C-16 | defaultSort('sort', 'desc') | E-02 L81 | ○ |
| C-17 | EditActionが存在（削除レコードで非表示） | E-02 L82-90 | ○ |
| C-18 | RestoreActionが存在 | E-02 L91-97 | ○ |
| C-19 | DeleteActionが存在 | E-02 L98-104 | ○ |
| C-20 | ForceDeleteActionが存在 | E-02 L105-122 | ○ |
| C-21 | ForceDeleteでQueryException処理 | E-02 L106-121 | ○ |
| C-22 | BulkActionGroupで一括操作 | E-02 L124-158 | ○ |
| C-23 | URLは/settings/projects/project-stages | E-02 L165 | ○ |

## 4) 不足情報（Unknown / Missing）
- 該当なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードで確認可能
- ProjectStageResource.phpとManageProjectStages.phpで完全に確認できる

## 6) レビュアーチェックリスト（最小）
- [ ] TaskSettings.enable_project_stages無効時のメニュー非表示を確認
- [ ] 一意制約違反時のエラーメッセージを確認
- [ ] 関連プロジェクトがある場合の完全削除エラーを確認
