---
generated_at: 2025-12-26 12:20:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：25-請求書一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **権限による表示制御**：権限設定の詳細実装未確認

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/accounts/src/Filament/Resources/InvoiceResource/Pages/ListInvoices.php`
- E-02: `plugins/webkul/accounts/src/Filament/Resources/InvoiceResource.php`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`（行26）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面種別がListRecords | E-01: ListRecords継承 | ○ |
| C-02 | HasTableViewsトレイトを使用 | E-01: use HasTableViews | ○ |
| C-03 | ヘッダーにCreateActionがある | E-01: getHeaderActions() | ○ |
| C-04 | 10種類のプリセットビューがある | E-01: getPresetTableViews() | ○ |
| C-05 | 請求書ビューがデフォルト・お気に入り | E-01: PresetView 'invoice' setAsDefault, favorite | ○ |
| C-06 | 各ビューのクエリ条件が正しい | E-01: modifyQueryUsing各所 | ○ |
| C-07 | モデルがAccountMove | E-02: $model = AccountMove::class | ○ |
| C-08 | レコードタイトル属性がname | E-02: $recordTitleAttribute = 'name' | ○ |
| C-09 | ナビゲーションアイコンがheroicon-o-receipt-percent | E-02: $navigationIcon | ○ |
| C-10 | テーブルが並び替え可能 | E-02: reorderableColumns() | ○ |
| C-11 | カラムマネージャーが2カラム | E-02: columnManagerColumns(2) | ○ |
| C-12 | 各テーブルカラムが定義されている | E-02: table()内のTextColumn各種 | ○ |
| C-13 | 金額カラムに集計（Sum）がある | E-02: summarize(Sum::make()) | ○ |
| C-14 | 金額が通貨フォーマットで表示 | E-02: money(fn ($record) => $record->currency?->name) | ○ |
| C-15 | グループ化オプションがある | E-02: groups配列 | ○ |
| C-16 | フィルタービルダーがある | E-02: QueryBuilder::make() | ○ |
| C-17 | 行アクションにView/Edit/Deleteがある | E-02: recordActions ActionGroup | ○ |
| C-18 | 一括削除アクションがある | E-02: toolbarActions DeleteBulkAction | ○ |
| C-19 | 成功通知が設定されている | E-02: successNotification各所 | ○ |
| C-20 | クエリがid降順 | E-02: getEloquentQuery() orderByDesc('id') | ○ |
| C-21 | 通貨をEager Load | E-02: modifyQueryUsing with('currency') | ○ |
| C-22 | payment_stateがバッジ表示 | E-02: TextColumn payment_state badge() | ○ |
| C-23 | グローバル検索結果の詳細がある | E-02: getGlobalSearchResultDetails() | ○ |
| C-24 | 画面一覧に登録されている | E-03: No.25 請求書一覧 | ○ |
| C-25 | 権限による表示制御の詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 権限設定の詳細はFilamentの権限設定またはポリシークラスの確認が必要
  - 候補：`MovePolicy.php` / `Filament Shield設定`
- account_movesテーブルのマイグレーション定義

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - テーブルカラム定義（ソースコードから明確）
- 0: 低リスク - プリセットビュー条件（ソースコードから明確）
- 0: 低リスク - フィルター設定（ソースコードから明確）
- 1: 中リスク - 権限制御の詳細（別ファイル参照必要）

## 6) レビュアーチェックリスト（最小）
- [ ] 権限設定の実装内容を確認
- [ ] 多言語ファイル（accounts::filament/resources/invoice/pages/list-invoice）の存在確認
- [ ] account_movesテーブルのマイグレーション定義との整合性確認
- [ ] MoveState, PaymentState, MoveType enumの定義確認
