---
generated_at: 2025-12-26 18:30:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：251-見積依頼一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **URL/ルーティング**：実際のルーティング設定ファイルでの確認が必要
  2. **権限による表示制御の詳細**：ポリシークラスの確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/purchases/src/Filament/Admin/Clusters/Orders/Resources/QuotationResource/Pages/ListQuotations.php`
- E-02: `plugins/webkul/purchases/src/Filament/Admin/Clusters/Orders/Resources/OrderResource/Pages/ListOrders.php`
- E-03: `plugins/webkul/purchases/src/Filament/Admin/Clusters/Orders/Resources/QuotationResource.php`
- E-04: `plugins/webkul/purchases/src/Filament/Admin/Clusters/Orders/Resources/OrderResource.php`
- E-05: `plugins/webkul/purchases/src/Models/Order.php`
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-08: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面は見積依頼一覧を表示する | E-01, E-02 | ○ |
| C-02 | ListQuotationsはListOrdersを継承 | E-01 | ○ |
| C-03 | 新規作成ボタンが存在 | E-01 (getHeaderActions) | ○ |
| C-04 | プリセットビューが7種類存在 | E-02 (getPresetTableViews) | ○ |
| C-05 | 優先度アイコンのクリックでpriority更新 | E-04 (table IconColumn) | ○ |
| C-06 | テーブルに12種類のカラムが存在 | E-04 (table columns) | ○ |
| C-07 | purchases_ordersテーブルを使用 | E-05 ($table) | ○ |
| C-08 | 削除時にDONE状態は非表示 | E-04 (DeleteAction hidden) | ○ |
| C-09 | 一括削除機能が存在 | E-04 (DeleteBulkAction) | ○ |
| C-10 | グループ化機能が存在 | E-04 (table groups) | ○ |
| C-11 | フィルター機能がモーダル表示 | E-04 (FiltersLayout::Modal) | ○ |
| C-12 | 通貨はレコード毎の設定を使用 | E-04 (money callback) | ○ |
| C-13 | カラムマネージャー機能あり | E-04 (columnManagerColumns) | ○ |
| C-14 | URL は /admin/purchases/orders/quotations | E-03 (getPages route) | △ |
| C-15 | OrderStateにDRAFT,SENT,PURCHASE,DONE,CANCELEDが存在 | E-02, E-04 | ○ |
| C-16 | 見積依頼番号はPO/XXX形式 | E-05 (updateName) | ○ |
| C-17 | HasTableViewsトレイトを使用 | E-02 | ○ |
| C-18 | 画面遷移先に作成・詳細・編集が存在 | E-03 (getPages) | ○ |
| C-19 | Ordersクラスターに所属 | E-03 ($cluster) | ○ |
| C-20 | ナビゲーションソート順は1 | E-03 ($navigationSort) | ○ |
| C-21 | FK制約違反時エラー通知 | E-04 (QueryException catch) | ○ |
| C-22 | 遅延注文は発注日が過去のもの | E-02 (late_orders) | ○ |
| C-23 | 権限による表示制御の詳細 | **根拠なし** | △ |
| C-24 | 関連データ削除時の挙動 | E-04 | ○ |
| C-25 | modifyQueryUsing で currency eager load | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- 権限（Policy）クラスの詳細実装が未確認
  - 候補：PurchasePolicy / OrderPolicy / QuotationPolicy
- 実際のルーティング設定ファイル（web.php等）での確認
  - 候補：routes/web.php / Filament Panel Provider

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的な一覧表示機能は十分に根拠あり
- 1: 中リスク - URLパスは推定値、実環境での確認推奨
- 0: 低リスク - プリセットビュー・フィルター機能は実装確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 実環境でURLパスが正しいか確認
- [ ] 権限制御が設計通りに動作するか確認
- [ ] 削除時のFK制約エラーハンドリングが適切か確認
- [ ] 各プリセットビューの絞り込み条件が業務要件と一致するか確認
