---
generated_at: 2025-12-26 18:32:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：252-見積依頼作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **金額計算ロジック詳細**：HasTotalsトレイトの実装確認が必要
  2. **税計算の詳細仕様**：税計算ロジックの確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/purchases/src/Filament/Admin/Clusters/Orders/Resources/QuotationResource/Pages/CreateQuotation.php`
- E-02: `plugins/webkul/purchases/src/Filament/Admin/Clusters/Orders/Resources/OrderResource/Pages/CreateOrder.php`
- E-03: `plugins/webkul/purchases/src/Filament/Admin/Clusters/Orders/Resources/OrderResource.php`
- E-04: `plugins/webkul/purchases/src/Models/Order.php`
- E-05: `plugins/webkul/purchases/src/Models/OrderLine.php`（推定）
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CreateQuotationはCreateOrderを継承 | E-01 | ○ |
| C-02 | フォームはOrderResourceで定義 | E-03 (form method) | ○ |
| C-03 | 仕入先選択でsub_type='supplier'フィルタ | E-03 | ○ |
| C-04 | 連絡先は仕入先に紐づくアドレスでフィルタ | E-03 (getPartnerAddresses) | ○ |
| C-05 | 商品選択でprice_unit自動設定 | E-03 (afterStateUpdated) | ○ |
| C-06 | 商品選択でproduct_uom_id自動設定 | E-03 (afterStateUpdated) | ○ |
| C-07 | 初期状態はDRAFT | E-02 (mutateFormDataBeforeCreate) | ○ |
| C-08 | creator_idは自動設定 | E-02 (mutateFormDataBeforeCreate) | ○ |
| C-09 | 保存後は編集画面に遷移 | E-02 (getRedirectUrl) | ○ |
| C-10 | 進捗ステッパーで状態表示 | E-03 (ProgressStepper) | ○ |
| C-11 | タブ構成で商品/その他/備考 | E-03 (Tabs make) | ○ |
| C-12 | 明細はRepeaterで入力 | E-03 (getProductsRepeater) | ○ |
| C-13 | 明細テーブル形式で表示 | E-03 (TableColumn) | ○ |
| C-14 | 税は複数選択可能 | E-03 (taxes Select multiple) | ○ |
| C-15 | 単位は設定により表示/非表示 | E-03 (enable_uom) | ○ |
| C-16 | 金額サマリー表示 | E-03 (getSummaryPlaceholder) | ○ |
| C-17 | インコタームズ選択可能 | E-03 (incoterm_id) | ○ |
| C-18 | 支払条件選択可能 | E-03 (payment_term_id) | ○ |
| C-19 | 財務ポジション選択可能 | E-03 (fiscal_position_id) | ○ |
| C-20 | 入庫タイプ選択可能 | E-03 (operation_type_id) | ○ |
| C-21 | RichEditorで備考入力 | E-03 (RichEditor description) | ○ |
| C-22 | 会社はデフォルト会社が初期値 | E-03 (default company_id) | ○ |
| C-23 | 仕入先は削除済み表示対応 | E-03 (withTrashed, Deleted表示) | ○ |
| C-24 | 商品は重複選択不可 | E-03 (distinct, disableOptionWhen) | ○ |
| C-25 | 金額計算ロジック詳細 | **根拠不足** | △ |
| C-26 | 税計算の詳細仕様 | **根拠不足** | △ |
| C-27 | 通貨レート自動設定 | E-03 (currency_rate) | ○ |
| C-28 | 成功通知のメッセージ表示 | E-02 (getCreatedNotification) | ○ |

## 4) 不足情報（Unknown / Missing）

- `HasTotals`トレイトの実装詳細が未確認
  - 候補：`plugins/webkul/purchases/src/Traits/HasTotals.php`
- `OrderLine`モデルの詳細構造が未確認
  - 候補：`plugins/webkul/purchases/src/Models/OrderLine.php`
- 税計算ロジックの実装詳細
  - 候補：税関連のサービスクラス

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - フォーム構成・項目定義は十分に根拠あり
- 1: 中リスク - 金額計算ロジックは別途確認必要
- 0: 低リスク - データベース項目は親クラスから確認可能

## 6) レビュアーチェックリスト（最小）

- [ ] 金額計算（税抜・税込・税額）のロジックが正しいか確認
- [ ] 商品選択時の価格取得ロジックが仕入先価格を考慮しているか確認
- [ ] 明細行の税計算が正しいか確認
- [ ] 作成後のリダイレクト先URLが正しいか確認
- [ ] 必須項目のバリデーションが適切か確認
