---
generated_at: 2025-12-26 18:38:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：254-見積依頼詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **カスタムフィールド表示の詳細**：カスタムフィールドの取得・表示ロジックの確認

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/purchases/src/Filament/Admin/Clusters/Orders/Resources/QuotationResource/Pages/ViewQuotation.php`
- E-02: `plugins/webkul/purchases/src/Filament/Admin/Clusters/Orders/Resources/OrderResource/Pages/ViewOrder.php`
- E-03: `plugins/webkul/purchases/src/Filament/Admin/Clusters/Orders/Resources/OrderResource.php`
- E-04: `plugins/webkul/purchases/src/Filament/Admin/Clusters/Orders/Resources/QuotationResource.php`
- E-05: `plugins/webkul/purchases/src/Models/Order.php`
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ViewQuotationはViewOrderを継承 | E-01 | ○ |
| C-02 | サブナビゲーションに詳細・編集が存在 | E-04 (getRecordSubNavigation) | ○ |
| C-03 | infolistメソッドで表示定義 | E-03 (infolist) | ○ |
| C-04 | ステータスバッジ表示 | E-03 (state TextEntry badge) | ○ |
| C-05 | 仕入先情報表示 | E-03 (partner.name) | ○ |
| C-06 | 購買担当者表示 | E-03 (user.name) | ○ |
| C-07 | 通貨表示 | E-03 (currency.name) | ○ |
| C-08 | 発注期限表示 | E-03 (ordered_at) | ○ |
| C-09 | 入荷予定日表示 | E-03 (planned_at) | ○ |
| C-10 | 明細はRepeatableEntryで表示 | E-03 (RepeatableEntry lines) | ○ |
| C-11 | 明細テーブル形式表示 | E-03 (InfolistTableColumn) | ○ |
| C-12 | 金額サマリー表示 | E-03 (untaxed_amount, tax_amount, total_amount) | ○ |
| C-13 | メタデータセクション表示 | E-03 (created_at, creator.name, updated_at) | ○ |
| C-14 | 確認アクションが存在 | E-02 (getHeaderActions) | ○ |
| C-15 | 発注確認アクションが存在 | E-02 (getHeaderActions) | ○ |
| C-16 | キャンセルアクションが存在 | E-02 (getHeaderActions) | ○ |
| C-17 | 印刷アクションが存在 | E-02 (getHeaderActions) | ○ |
| C-18 | タブ構成で商品/その他/備考 | E-03 (Tabs infolist) | ○ |
| C-19 | カスタムフィールド表示 | E-03 (getCustomInfolistEntries) | △ |
| C-20 | 備考はMarkdown表示 | E-03 (description markdown) | ○ |
| C-21 | URLパターン /quotations/{record} | E-04 (getPages) | ○ |
| C-22 | インコタームズ情報表示 | E-03 (incoterm.name) | ○ |

## 4) 不足情報（Unknown / Missing）

- `getCustomInfolistEntries`メソッドの詳細実装
  - 候補：`HasCustomFields`トレイトの実装
- ViewOrderトレイトの詳細（ヘッダーアクション共有の仕組み）
  - 候補：関連トレイトまたは継承クラス

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 表示項目は十分に根拠あり
- 0: 低リスク - アクションボタンは編集画面と共通
- 0: 低リスク - Infolist構成は明確に定義されている

## 6) レビュアーチェックリスト（最小）

- [ ] 全ての表示項目が正しく表示されるか確認
- [ ] アクションボタンの表示条件が正しいか確認
- [ ] 明細テーブルの表示フォーマットが適切か確認
- [ ] 金額表示の通貨フォーマットが正しいか確認
- [ ] カスタムフィールドが設定されている場合の表示確認
- [ ] 閲覧権限のみのユーザーでの表示確認
