---
generated_at: 2025-12-26 18:41:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：255-発注書一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **URL/ルーティング**：実際のルーティング設定での確認

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/purchases/src/Filament/Admin/Clusters/Orders/Resources/PurchaseOrderResource/Pages/ListPurchaseOrders.php`
- E-02: `plugins/webkul/purchases/src/Filament/Admin/Clusters/Orders/Resources/OrderResource/Pages/ListOrders.php`
- E-03: `plugins/webkul/purchases/src/Filament/Admin/Clusters/Orders/Resources/PurchaseOrderResource.php`
- E-04: `plugins/webkul/purchases/src/Filament/Admin/Clusters/Orders/Resources/OrderResource.php`
- E-05: `plugins/webkul/purchases/src/Models/PurchaseOrder.php`
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ListPurchaseOrdersはListOrdersを継承 | E-01 | ○ |
| C-02 | PurchaseOrderResourceはOrderResourceを継承 | E-03 | ○ |
| C-03 | 新規作成ボタンが存在 | E-02 (getHeaderActions) | ○ |
| C-04 | プリセットビューが4種類存在 | E-01 (getPresetTableViews) | ○ |
| C-05 | my_orders（マイ発注）ビュー存在 | E-01 | ○ |
| C-06 | starred_orders（スター付き）ビュー存在 | E-01 | ○ |
| C-07 | waiting-bills（請求待ち）ビュー存在 | E-01 | ○ |
| C-08 | received-bills（請求受領済み）ビュー存在 | E-01 | ○ |
| C-09 | modifyQueryUsingでstate絞り込み | E-03 (table modifyQueryUsing) | ○ |
| C-10 | PURCHASE/DONE状態のみ表示 | E-03 (OrderState::PURCHASE, OrderState::DONE) | ○ |
| C-11 | テーブルカラムは親クラスと共通 | E-04 (table columns) | ○ |
| C-12 | 優先度アイコンでpriority更新 | E-04 (IconColumn toggle) | ○ |
| C-13 | 削除アクション存在 | E-04 (DeleteAction) | ○ |
| C-14 | 一括削除アクション存在 | E-04 (DeleteBulkAction) | ○ |
| C-15 | FK制約違反時エラー通知 | E-04 (QueryException catch) | ○ |
| C-16 | ナビゲーションソート順は2 | E-03 ($navigationSort) | ○ |
| C-17 | Ordersクラスターに所属 | E-03 ($cluster) | ○ |
| C-18 | PurchaseOrderモデルを使用 | E-03 ($model) | ○ |
| C-19 | URLパターン /purchase-orders | E-03 (getPages route) | △ |
| C-20 | HasTableViewsトレイトを使用 | E-01 | ○ |

## 4) 不足情報（Unknown / Missing）

- 実際のルーティング設定ファイルでのURL確認
  - 候補：routes/web.php / Filament Panel Provider

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 一覧表示機能は十分に根拠あり
- 0: 低リスク - 継承構造によりOrderResourceの機能を継承
- 0: 低リスク - ステータス絞り込みは明確に実装されている

## 6) レビュアーチェックリスト（最小）

- [ ] 実環境でURLパスが正しいか確認
- [ ] PURCHASE/DONEのみ表示されることを確認
- [ ] 各プリセットビューの絞り込み条件が正しいか確認
- [ ] 削除時のFK制約エラーハンドリングが適切か確認
- [ ] 見積依頼が本一覧に表示されないことを確認
