---
generated_at: 2025-12-26 18:44:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：256-発注書作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **初期ステータスの確認**：見積依頼と同様DRAFTで開始するか確認

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/purchases/src/Filament/Admin/Clusters/Orders/Resources/PurchaseOrderResource/Pages/CreatePurchaseOrder.php`
- E-02: `plugins/webkul/purchases/src/Filament/Admin/Clusters/Orders/Resources/OrderResource/Pages/CreateOrder.php`
- E-03: `plugins/webkul/purchases/src/Filament/Admin/Clusters/Orders/Resources/PurchaseOrderResource.php`
- E-04: `plugins/webkul/purchases/src/Filament/Admin/Clusters/Orders/Resources/OrderResource.php`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CreatePurchaseOrderはCreateOrderを継承 | E-01 | ○ |
| C-02 | resourceプロパティがPurchaseOrderResource | E-01 | ○ |
| C-03 | フォームはOrderResourceで定義 | E-04 | ○ |
| C-04 | 見積依頼作成と同一のフォーム構造 | E-01, E-02, E-04 | ○ |
| C-05 | 仕入先選択で連絡先フィルタリング | E-04 | ○ |
| C-06 | 商品選択で価格自動設定 | E-04 | ○ |
| C-07 | creator_idは自動設定 | E-02 (mutateFormDataBeforeCreate) | ○ |
| C-08 | 初期stateはDRAFT | E-02 (mutateFormDataBeforeCreate) | ○ |
| C-09 | 保存後は編集画面に遷移 | E-02 (getRedirectUrl) | ○ |
| C-10 | 進捗ステッパーで状態表示 | E-04 (ProgressStepper) | ○ |
| C-11 | タブ構成で商品/その他/備考 | E-04 (Tabs) | ○ |
| C-12 | 明細はRepeaterで入力 | E-04 (getProductsRepeater) | ○ |
| C-13 | 会社はデフォルト会社が初期値 | E-04 (default company_id) | ○ |
| C-14 | 成功通知のメッセージ表示 | E-02 (getCreatedNotification) | ○ |
| C-15 | URLパターン /purchase-orders/create | E-03 (getPages) | ○ |
| C-16 | 削除済み仕入先は選択不可 | E-04 (disableOptionWhen) | ○ |
| C-17 | 発注確認操作が別途必要 | E-02 | △ |
| C-18 | 金額は自動計算 | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）

- 発注書作成と見積依頼作成の業務フロー上の違いの詳細
  - 候補：業務フロー設計書または要件定義書
- 直接発注書を作成する場合のユースケース詳細
  - 候補：ユースケース定義書

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 継承構造により見積依頼作成と同一の機能を提供
- 0: 低リスク - フォーム定義は親クラスで確認済み
- 1: 中リスク - 発注書固有のビジネスロジックがある場合は要確認

## 6) レビュアーチェックリスト（最小）

- [ ] 発注書作成時の初期ステータスがDRAFTであることを確認
- [ ] 見積依頼と同一のフォームが表示されることを確認
- [ ] 作成後のリダイレクト先が発注書編集画面であることを確認
- [ ] 発注確認操作なしでは入庫オペレーションが生成されないことを確認
- [ ] 発注書と見積依頼の使い分けが業務要件と一致するか確認
