---
generated_at: 2025-12-26 18:50:00
metrics:
  claims_total: 20
  claims_with_evidence: 18
  claims_without_evidence: 2
confidence_derived: 0.90
---

# 根拠レポート：258-発注書詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.90**
  - 根拠あり：18 / 20、根拠なし：2
- 優先レビュー（高）
  1. **請求書作成ボタンの表示条件**：条件の詳細確認が必要
  2. **完了ボタンの表示条件**：条件の詳細確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/purchases/src/Filament/Admin/Clusters/Orders/Resources/PurchaseOrderResource/Pages/ViewPurchaseOrder.php`
- E-02: `plugins/webkul/purchases/src/Filament/Admin/Clusters/Orders/Resources/OrderResource/Pages/ViewOrder.php`
- E-03: `plugins/webkul/purchases/src/Filament/Admin/Clusters/Orders/Resources/PurchaseOrderResource.php`
- E-04: `plugins/webkul/purchases/src/Filament/Admin/Clusters/Orders/Resources/OrderResource.php`
- E-05: `plugins/webkul/purchases/src/Models/Order.php`
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ViewPurchaseOrderはViewOrderを継承 | E-01 | ○ |
| C-02 | サブナビゲーションに請求書・入庫追加 | E-03 (getRecordSubNavigation) | ○ |
| C-03 | infolistメソッドで表示定義 | E-04 (infolist) | ○ |
| C-04 | ステータスバッジ表示 | E-04 (state TextEntry badge) | ○ |
| C-05 | 入庫ステータス表示 | E-04 (receipt_status) | ○ |
| C-06 | 請求ステータス表示 | E-04 (invoice_status) | ○ |
| C-07 | 仕入先情報表示 | E-04 (partner.name) | ○ |
| C-08 | 購買担当者表示 | E-04 (user.name) | ○ |
| C-09 | 明細はRepeatableEntryで表示 | E-04 (RepeatableEntry lines) | ○ |
| C-10 | 入庫済数量表示 | E-04 (qty_received) | ○ |
| C-11 | 請求済数量表示 | E-04 (qty_invoiced) | ○ |
| C-12 | 請求書作成アクション | E-02 | △ |
| C-13 | 完了アクション | E-02 | △ |
| C-14 | キャンセルアクション | E-02 | ○ |
| C-15 | 印刷アクション | E-02 | ○ |
| C-16 | タブ構成で商品/その他/備考 | E-04 (Tabs infolist) | ○ |
| C-17 | 備考はMarkdown表示 | E-04 (description markdown) | ○ |
| C-18 | URLパターン /purchase-orders/{record} | E-03 (getPages) | ○ |
| C-19 | メタデータセクション表示 | E-04 (created_at, creator.name) | ○ |
| C-20 | 金額サマリー表示 | E-04 (untaxed_amount, total_amount) | ○ |

## 4) 不足情報（Unknown / Missing）

- 請求書作成アクションの表示条件詳細
  - 候補：`createBillAction`の実装
- 完了アクションの表示条件詳細
  - 候補：`doneAction`の実装

## 5) リスクフラグ（レビュー観点）

- 0: 低リスク - 表示項目は十分に根拠あり
- 0: 低リスク - サブナビゲーション構成は確認済み
- 1: 中リスク - アクションボタンの条件付き表示は要確認

## 6) レビュアーチェックリスト（最小）

- [ ] サブナビゲーションに請求書・入庫が表示されることを確認
- [ ] 入庫済み数量・請求済み数量が正しく表示されるか確認
- [ ] 入庫ステータス・請求ステータスが正しく表示されるか確認
- [ ] アクションボタンの表示条件が正しいか確認
- [ ] 閲覧権限のみのユーザーでの表示確認
